/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.definition;

import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.InjectableFactory;
import hs.ddif.core.instantiation.injection.Constructable;
import hs.ddif.core.instantiation.injection.Injection;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class InstanceInjectableFactory {
    private final InjectableFactory factory;
    private final Annotation singleton;

    public InstanceInjectableFactory(InjectableFactory factory, Annotation singleton) {
        this.factory = Objects.requireNonNull(factory, "factory cannot be null");
        this.singleton = Objects.requireNonNull(singleton, "singleton cannot be null");
    }

    public <T> Injectable<T> create(final T instance, Annotation ... qualifiers) {
        if (instance == null) {
            throw new IllegalArgumentException("instance cannot be null");
        }
        Annotation[] extendedQualifiers = Arrays.copyOf(qualifiers, qualifiers.length + 1);
        extendedQualifiers[extendedQualifiers.length - 1] = this.singleton;
        return this.factory.create(instance.getClass(), null, new FakeAnnotatedElement(instance, extendedQualifiers), List.of(), new Constructable<T>(){

            @Override
            public T create(List<Injection> injections) {
                return instance;
            }

            @Override
            public void destroy(T instance2) {
            }
        });
    }

    private static class FakeAnnotatedElement
    implements AnnotatedElement {
        private final Object instance;
        private final Annotation[] qualifiers;

        FakeAnnotatedElement(Object instance, Annotation ... qualifiers) {
            this.instance = instance;
            this.qualifiers = qualifiers;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)((Annotation)Arrays.stream(this.qualifiers).filter(q -> q.annotationType().equals(annotationClass)).findFirst().orElse(null));
        }

        @Override
        public Annotation[] getAnnotations() {
            return (Annotation[])this.qualifiers.clone();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return (Annotation[])this.qualifiers.clone();
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FakeAnnotatedElement other = (FakeAnnotatedElement)obj;
            return Objects.equals(this.instance, other.instance);
        }
    }
}

