/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.definition;

import hs.ddif.core.definition.BadQualifiedTypeException;
import hs.ddif.core.util.Primitives;
import hs.ddif.core.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class QualifiedType {
    private final Type type;
    private final Set<Annotation> qualifiers;

    public QualifiedType(Type type, Collection<Annotation> qualifiers) throws BadQualifiedTypeException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (qualifiers == null) {
            throw new IllegalArgumentException("qualifiers cannot be null");
        }
        this.type = Primitives.toBoxed(type);
        this.qualifiers = Collections.unmodifiableSet(new HashSet<Annotation>(qualifiers));
        if (!(type instanceof Class) && !(type instanceof ParameterizedType) || Types.containsTypeVariables(type)) {
            throw new BadQualifiedTypeException("[" + this + "] cannot have unresolvable type variables or wild cards");
        }
        if (type == Void.TYPE || type == Void.class) {
            throw new BadQualifiedTypeException("[" + this + "] cannot be void or Void");
        }
    }

    public QualifiedType(Type type) throws BadQualifiedTypeException {
        this(type, Set.of());
    }

    public Type getType() {
        return this.type;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String toString() {
        return (String)(this.qualifiers.isEmpty() ? "" : this.qualifiers.stream().map(Object::toString).sorted().collect(Collectors.joining(" ")) + " ") + this.type.getTypeName();
    }

    public int hashCode() {
        return Objects.hash(this.type, this.qualifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedType other = (QualifiedType)obj;
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.qualifiers.equals(other.qualifiers);
    }
}

