/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.definition.bind;

import hs.ddif.core.definition.bind.AnnotationStrategy;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.definition.bind.BindingException;
import hs.ddif.core.store.Key;
import hs.ddif.core.util.Types;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class BindingProvider {
    private final AnnotationStrategy annotationStrategy;

    public BindingProvider(AnnotationStrategy annotationStrategy) {
        this.annotationStrategy = Objects.requireNonNull(annotationStrategy, "annotationStrategy cannot be null");
    }

    public List<Binding> ofConstructorAndMembers(Constructor<?> constructor, Class<?> cls) throws BindingException {
        List<Binding> bindings = this.ofConstructor(constructor);
        bindings.addAll(this.ofMembers(cls));
        return bindings;
    }

    public List<Binding> ofConstructor(Constructor<?> constructor) {
        return this.ofExecutable(constructor, constructor.getDeclaringClass());
    }

    public List<Binding> ofMembers(Class<?> cls) throws BindingException {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Map<TypeVariable<?>, Type> typeArguments = null;
        for (Class<?> currentInjectableClass = cls; currentInjectableClass != null; currentInjectableClass = currentInjectableClass.getSuperclass()) {
            for (Field field : currentInjectableClass.getDeclaredFields()) {
                if (!this.annotationStrategy.isInjectAnnotated(field)) continue;
                if (Modifier.isFinal(field.getModifiers())) {
                    throw new BindingException(cls, field, "cannot be final");
                }
                if (!this.annotationStrategy.getScopes(field).isEmpty()) {
                    throw new BindingException(cls, field, "should not be annotated with a scope annotation when it is annotated with an inject annotation: " + this.annotationStrategy.getScopes(field));
                }
                if (typeArguments == null && (typeArguments = Types.getTypeArguments(cls, Object.class)) == null) {
                    throw new IllegalArgumentException("ownerType must be assignable to field's declaring class: " + cls + "; declaring class: " + currentInjectableClass);
                }
                Type type = Types.resolveVariables(typeArguments, field.getGenericType());
                bindings.add(new DefaultBinding(new Key(type, this.annotationStrategy.getQualifiers(field)), field, null));
            }
            for (Method method : currentInjectableClass.getDeclaredMethods()) {
                if (!this.annotationStrategy.isInjectAnnotated(method)) continue;
                if (method.getParameterCount() == 0) {
                    throw new BindingException(cls, method, "must have parameters");
                }
                if (!this.annotationStrategy.getScopes(method).isEmpty()) {
                    throw new BindingException(cls, method, "should not be annotated with a scope annotation when it is annotated with an inject annotation: " + this.annotationStrategy.getScopes(method));
                }
                bindings.addAll(this.ofExecutable(method, cls));
            }
        }
        for (Binding binding : bindings) {
            binding.getAccessibleObject().setAccessible(true);
        }
        return bindings;
    }

    public List<Binding> ofMethod(Method method, Type ownerType) {
        List<Binding> bindings = this.ofExecutable(method, ownerType);
        if (!Modifier.isStatic(method.getModifiers())) {
            bindings.add(BindingProvider.ownerBinding(ownerType));
        }
        return bindings;
    }

    public List<Binding> ofField(Field field, Type ownerType) {
        return Modifier.isStatic(field.getModifiers()) ? List.of() : List.of(BindingProvider.ownerBinding(ownerType));
    }

    public Constructor<?> getAnnotatedConstructor(Class<?> cls) throws BindingException {
        return this.getConstructor(cls, true);
    }

    public <T> Constructor<T> getConstructor(Class<T> cls) throws BindingException {
        return this.getConstructor(cls, false);
    }

    private <T> Constructor<T> getConstructor(Class<T> cls, boolean annotatedOnly) throws BindingException {
        Constructor<?>[] declaredConstructors;
        Constructor<?> suitableConstructor = null;
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : declaredConstructors = cls.getDeclaredConstructors()) {
            if (this.annotationStrategy.isInjectAnnotated(constructor)) {
                if (suitableConstructor != null) {
                    throw new BindingException(cls, "cannot have multiple Inject annotated constructors");
                }
                suitableConstructor = constructor;
                continue;
            }
            if (annotatedOnly || constructor.getParameterCount() != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            defaultConstructor = constructor;
        }
        if (suitableConstructor == null && defaultConstructor == null) {
            throw new BindingException(cls, "should have at least one suitable constructor; annotate a constructor" + (annotatedOnly ? "" : " or provide an empty public constructor"));
        }
        return suitableConstructor == null ? defaultConstructor : suitableConstructor;
    }

    private List<Binding> ofExecutable(Executable executable, Type ownerType) {
        Type[] params = executable.getGenericParameterTypes();
        Parameter[] parameters = executable.getParameters();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Map<TypeVariable<?>, Type> typeArguments = Types.getTypeArguments(ownerType, executable.getDeclaringClass());
        if (typeArguments == null) {
            throw new IllegalArgumentException("ownerType must be assignable to declaring class: " + ownerType + "; declaring class: " + executable.getDeclaringClass());
        }
        for (int i = 0; i < parameters.length; ++i) {
            Type type = Types.resolveVariables(typeArguments, params[i]);
            bindings.add(new DefaultBinding(new Key(type, this.annotationStrategy.getQualifiers(parameters[i])), executable, parameters[i]));
        }
        return bindings;
    }

    private static Binding ownerBinding(Type ownerType) {
        return new DefaultBinding(new Key(ownerType), null, null);
    }

    private static class DefaultBinding
    implements Binding {
        private final Key key;
        private final AccessibleObject accessibleObject;
        private final Parameter parameter;

        public DefaultBinding(Key key, AccessibleObject accessibleObject, Parameter parameter) {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            if (accessibleObject instanceof Executable && parameter == null) {
                throw new IllegalArgumentException("parameter cannot be null when accessibleObject is an instance of Executable");
            }
            if (!(accessibleObject instanceof Executable) && parameter != null) {
                throw new IllegalArgumentException("parameter must be null when accessibleObject is not an instance of Executable");
            }
            this.key = key;
            this.accessibleObject = accessibleObject;
            this.parameter = parameter;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public AccessibleObject getAccessibleObject() {
            return this.accessibleObject;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        public int hashCode() {
            return Objects.hash(this.accessibleObject, this.key, this.parameter);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultBinding other = (DefaultBinding)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.accessibleObject, other.accessibleObject) && Objects.equals(this.parameter, other.parameter);
        }

        public String toString() {
            if (this.accessibleObject instanceof Executable) {
                int index = Arrays.asList(((Executable)this.accessibleObject).getParameters()).indexOf(this.parameter);
                return "Parameter " + index + " [" + this.key.getType() + "] of [" + this.accessibleObject + "]";
            }
            if (this.accessibleObject != null) {
                return "Field [" + (String)(this.getKey().getQualifiers().isEmpty() ? "" : this.getKey().getQualifiers().stream().map(Object::toString).collect(Collectors.joining(" ")) + " ") + ((Field)this.accessibleObject).toGenericString() + "]";
            }
            return "Owner Type [" + this.key.getType() + "]";
        }
    }
}

