/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.inject.store;

import hs.ddif.core.definition.Injectable;
import hs.ddif.core.inject.store.InjectorStoreConsistencyException;
import java.util.Collections;
import java.util.List;

public class CyclicDependencyException
extends InjectorStoreConsistencyException {
    private final List<? extends Injectable<?>> cycle;

    public CyclicDependencyException(List<? extends Injectable<?>> cycle) {
        super("Cyclic dependency detected in chain:\n" + CyclicDependencyException.format(cycle));
        this.cycle = Collections.unmodifiableList(cycle);
    }

    public List<? extends Injectable<?>> getCycle() {
        return this.cycle;
    }

    private static String format(List<? extends Injectable<?>> cycle) {
        StringBuilder b = new StringBuilder();
        b.append("     -----\n");
        b.append("    |     |\n");
        for (Injectable<?> i : cycle) {
            b.append("    |     V\n");
            b.append("    | " + i + "\n");
            b.append("    |     |\n");
        }
        b.append("     -----\n");
        return b.toString();
    }
}

