/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.inject.store;

import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.inject.store.BindingManager;
import hs.ddif.core.inject.store.CyclicDependencyException;
import hs.ddif.core.inject.store.ScopeConflictException;
import hs.ddif.core.inject.store.UnresolvableDependencyException;
import hs.ddif.core.inject.store.ViolatesSingularDependencyException;
import hs.ddif.core.instantiation.TypeTrait;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.store.FilteredKeyException;
import hs.ddif.core.store.Key;
import hs.ddif.core.store.QualifiedTypeStore;
import hs.ddif.core.store.Resolver;
import hs.ddif.core.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class InjectableStore
implements Resolver<Injectable<?>> {
    private static final Class<Object> SINGLETON = Object.class;
    private final BindingManager bindingManager;
    private final Map<Class<?>, Map<Key, Node>> nodes = new HashMap();
    private final QualifiedTypeStore<Injectable<?>> qualifiedTypeStore;

    public InjectableStore(BindingManager bindingManager, Set<Class<?>> extendedTypes) {
        this.bindingManager = Objects.requireNonNull(bindingManager, "bindingManager cannot be null");
        this.qualifiedTypeStore = new QualifiedTypeStore<Injectable>(i -> new Key(i.getType(), i.getQualifiers()), cls -> !extendedTypes.contains(cls));
    }

    @Override
    public Set<Injectable<?>> resolve(Key key) {
        Node node;
        Map<Key, Node> map = this.nodes.get(Types.raw(key.getType()));
        if (map != null && (node = map.get(key)) != null) {
            return new HashSet(node.sources);
        }
        return this.qualifiedTypeStore.resolve(key);
    }

    public boolean contains(Key key) {
        return this.qualifiedTypeStore.contains(key);
    }

    public synchronized void putAll(Collection<Injectable<?>> injectables) {
        try {
            this.qualifiedTypeStore.putAll(injectables);
        }
        catch (FilteredKeyException e) {
            throw new DefinitionException("[" + e.getInjectable() + "] cannot be registered as its type conflicts with a TypeExtension for " + Types.raw(e.getKey().getType()), e);
        }
        try {
            this.addBindings(injectables);
            try {
                this.ensureNoCyclicDependencies(injectables);
                for (Injectable<?> injectable : injectables) {
                    this.ensureRequiredBindingsAreAvailable(injectable);
                }
                this.addInjectables(injectables).ifPresent(violation -> {
                    this.removeInjectables(injectables);
                    violation.doThrow();
                });
            }
            catch (Exception e) {
                this.removeBindings(injectables);
                throw e;
            }
        }
        catch (Exception e) {
            this.qualifiedTypeStore.removeAll(injectables);
            throw e;
        }
    }

    public synchronized void removeAll(Collection<Injectable<?>> injectables) {
        this.qualifiedTypeStore.removeAll(injectables);
        try {
            this.removeInjectables(injectables).ifPresent(violation -> {
                this.addInjectables(injectables);
                violation.doThrow();
            });
            this.removeBindings(injectables);
            InjectableStore.removeScopedInstances(injectables);
        }
        catch (Exception e) {
            this.qualifiedTypeStore.putAll(injectables);
            throw e;
        }
    }

    private void addBindings(Collection<Injectable<?>> injectables) {
        for (Injectable<?> injectable : injectables) {
            for (Binding binding : injectable.getBindings()) {
                this.bindingManager.addBinding(binding);
            }
        }
    }

    private void removeBindings(Collection<Injectable<?>> injectables) {
        for (Injectable<?> injectable : injectables) {
            for (Binding binding : injectable.getBindings()) {
                this.bindingManager.removeBinding(binding);
            }
        }
    }

    private static void removeScopedInstances(Collection<Injectable<?>> injectables) {
        for (Injectable<?> injectable : injectables) {
            injectable.getScopeResolver().remove(injectable);
        }
    }

    private Optional<Violation> addInjectables(Collection<Injectable<?>> injectables) {
        for (Injectable<?> injectable : injectables) {
            for (Binding binding : injectable.getBindings()) {
                Set<TypeTrait> typeTraits = this.bindingManager.getTypeTraits(binding);
                Key key = this.bindingManager.getSearchKey(binding);
                this.addTarget(key, typeTraits.contains((Object)TypeTrait.REQUIRES_AT_LEAST_ONE), typeTraits.contains((Object)TypeTrait.REQUIRES_AT_MOST_ONE), injectables);
            }
        }
        return this.addSources(injectables);
    }

    private Optional<Violation> removeInjectables(Collection<Injectable<?>> injectables) {
        for (Injectable<?> injectable : injectables) {
            for (Binding binding : injectable.getBindings()) {
                Set<TypeTrait> typeTraits = this.bindingManager.getTypeTraits(binding);
                Key key = this.bindingManager.getSearchKey(binding);
                this.removeTarget(key, typeTraits.contains((Object)TypeTrait.REQUIRES_AT_LEAST_ONE), typeTraits.contains((Object)TypeTrait.REQUIRES_AT_MOST_ONE));
            }
        }
        return this.removeSources(injectables);
    }

    private void ensureRequiredBindingsAreAvailable(Injectable<?> injectable) {
        for (Binding binding : injectable.getBindings()) {
            Set<TypeTrait> typeTraits = this.bindingManager.getTypeTraits(binding);
            if (!typeTraits.contains((Object)TypeTrait.REQUIRES_AT_MOST_ONE)) continue;
            Key key = this.bindingManager.getSearchKey(binding);
            Set<Injectable<?>> injectables = this.qualifiedTypeStore.resolve(key);
            if (injectables.size() > 1 || typeTraits.contains((Object)TypeTrait.REQUIRES_AT_LEAST_ONE) && injectables.size() < 1) {
                throw new UnresolvableDependencyException(key, binding, injectables);
            }
            if (typeTraits.contains((Object)TypeTrait.LAZY) || injectables.isEmpty()) continue;
            Injectable<?> dependency = injectables.iterator().next();
            InjectableStore.ensureBindingScopeIsValid(injectable, dependency);
        }
    }

    private static void ensureBindingScopeIsValid(Injectable<?> injectable, Injectable<?> dependentInjectable) {
        Class<Object> injectableScopeAnnotation;
        ScopeResolver dependentScopeResolver = dependentInjectable.getScopeResolver();
        ScopeResolver injectableScopeResolver = injectable.getScopeResolver();
        Class<Object> dependendentScopeAnnotation = dependentScopeResolver.isSingleton() ? SINGLETON : dependentScopeResolver.getAnnotationClass();
        Class<Object> clazz = injectableScopeAnnotation = injectableScopeResolver.isSingleton() ? SINGLETON : injectableScopeResolver.getAnnotationClass();
        if (InjectableStore.isNarrowerScope(injectableScopeAnnotation, dependendentScopeAnnotation)) {
            throw new ScopeConflictException(injectable + " is dependent on narrower scoped dependency: " + dependentInjectable.getType());
        }
    }

    private void ensureNoCyclicDependencies(final Collection<Injectable<?>> injectables) {
        class CycleDetector {
            Set<Injectable<?>> input;
            Set<Injectable<?>> visited;
            List<Injectable<?>> visiting;

            CycleDetector() {
                this.input = new HashSet(injectables);
                this.visited = new HashSet();
                this.visiting = new ArrayList();
            }

            List<Injectable<?>> hasCycle() {
                for (Injectable injectable : injectables) {
                    if (this.visited.contains(injectable) || !this.hasCycle(injectable)) continue;
                    return this.visiting;
                }
                return this.visiting;
            }

            boolean hasCycle(Injectable<?> injectable) {
                this.visiting.add(injectable);
                for (Binding binding : injectable.getBindings()) {
                    Set<TypeTrait> typeTraits = InjectableStore.this.bindingManager.getTypeTraits(binding);
                    if (typeTraits.contains((Object)TypeTrait.LAZY)) continue;
                    Key key = binding.getKey();
                    for (Injectable<?> boundInjectable : InjectableStore.this.qualifiedTypeStore.resolve(key)) {
                        if (this.visiting.contains(boundInjectable)) {
                            return true;
                        }
                        if (this.visited.contains(boundInjectable) || !this.input.contains(boundInjectable) || !this.hasCycle(boundInjectable)) continue;
                        return true;
                    }
                }
                this.visiting.remove(injectable);
                this.visited.add(injectable);
                return false;
            }
        }
        List<Injectable<?>> cycle = new CycleDetector().hasCycle();
        if (!cycle.isEmpty()) {
            throw new CyclicDependencyException(cycle);
        }
    }

    void checkInvariants() {
        for (Map<Key, Node> map : this.nodes.values()) {
            for (Node node : map.values()) {
                if (!node.isInvalid()) continue;
                throw new IllegalStateException(node.toString());
            }
        }
    }

    private static boolean isNarrowerScope(Class<?> scope, Class<?> dependencyScope) {
        if (scope == null || dependencyScope == null) {
            return false;
        }
        return !dependencyScope.equals(SINGLETON) && !scope.equals(dependencyScope);
    }

    private Optional<Violation> addSources(Collection<Injectable<?>> sources) {
        Violation violation = null;
        for (Injectable<?> source : sources) {
            Type type = source.getType();
            Set<Annotation> qualifiers = source.getQualifiers();
            for (Class<?> cls : Types.getSuperTypes(Types.raw(type))) {
                Map<Key, Node> nodesByKeys = this.nodes.get(cls);
                if (nodesByKeys == null) continue;
                for (Key key : nodesByKeys.keySet()) {
                    if (!Types.isAssignable(type, key.getType()) || !qualifiers.containsAll(key.getQualifiers())) continue;
                    Node node = nodesByKeys.get(key);
                    node.increaseSources(source);
                    if (violation != null || !node.isInvalid()) continue;
                    violation = new Violation(type, key, true);
                }
            }
        }
        return Optional.ofNullable(violation);
    }

    private Optional<Violation> removeSources(Collection<Injectable<?>> sources) {
        Violation violation = null;
        for (Injectable<?> source : sources) {
            Type type = source.getType();
            Set<Annotation> qualifiers = source.getQualifiers();
            for (Class<?> cls : Types.getSuperTypes(Types.raw(type))) {
                Map<Key, Node> nodesByKeys = this.nodes.get(cls);
                if (nodesByKeys == null) continue;
                for (Key key : nodesByKeys.keySet()) {
                    if (!Types.isAssignable(type, key.getType()) || !qualifiers.containsAll(key.getQualifiers())) continue;
                    Node node = nodesByKeys.get(key);
                    node.decreaseSources(source);
                    if (violation != null || !node.isInvalid()) continue;
                    violation = new Violation(type, key, false);
                }
            }
        }
        return Optional.ofNullable(violation);
    }

    private void addTarget(Key key, boolean minimumOne, boolean maximumOne, Collection<Injectable<?>> sources) {
        Class cls = Types.raw(key.getType());
        this.nodes.computeIfAbsent(cls, k -> new HashMap()).computeIfAbsent(key, k -> {
            Set<Injectable<?>> candidates = this.qualifiedTypeStore.resolve(key);
            Node node = new Node(candidates);
            for (Injectable source : sources) {
                if (!candidates.contains(source)) continue;
                node.decreaseSources(source);
            }
            return node;
        }).increaseTargets(minimumOne, maximumOne);
    }

    private void removeTarget(Key key, boolean minimumOne, boolean maximumOne) {
        Class cls = Types.raw(key.getType());
        this.nodes.computeIfPresent(cls, (c, m) -> m.computeIfPresent(key, (k, n) -> n.decreaseTargets(minimumOne, maximumOne) ? null : n) == null ? null : m);
    }

    private static class Node {
        int minimumOneReferences;
        int maximumOneReferences;
        int references;
        final Set<Injectable<?>> sources;

        Node(Set<Injectable<?>> sources) {
            this.sources = new HashSet(sources);
        }

        boolean increaseTargets(boolean minimumOne, boolean maximumOne) {
            this.minimumOneReferences += minimumOne ? 1 : 0;
            this.maximumOneReferences += maximumOne ? 1 : 0;
            ++this.references;
            return this.references == 0;
        }

        boolean decreaseTargets(boolean minimumOne, boolean maximumOne) {
            this.minimumOneReferences -= minimumOne ? 1 : 0;
            this.maximumOneReferences -= maximumOne ? 1 : 0;
            --this.references;
            return this.references == 0;
        }

        void increaseSources(Injectable<?> source) {
            if (!this.sources.add(source)) {
                throw new AssertionError((Object)("Node already contained source: " + source));
            }
        }

        void decreaseSources(Injectable<?> source) {
            if (!this.sources.remove(source)) {
                throw new AssertionError((Object)("Node did not contain source: " + source + "; available: " + this.sources));
            }
        }

        boolean isInvalid() {
            return this.minimumOneReferences > 0 && this.sources.size() < 1 || this.maximumOneReferences > 0 && this.sources.size() > 1 || this.references == 0;
        }

        public String toString() {
            return "Node[>0 = " + this.minimumOneReferences + "; <2 = " + this.maximumOneReferences + "; references = " + this.references + "; sources = " + this.sources + "]";
        }
    }

    private static class Violation {
        final Type type;
        final Key key;
        final boolean isAdd;

        Violation(Type type, Key key, boolean isAdd) {
            this.type = type;
            this.key = key;
            this.isAdd = isAdd;
        }

        void doThrow() {
            throw new ViolatesSingularDependencyException(this.type, this.key, this.isAdd);
        }
    }
}

