/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.inject.store;

import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.inject.store.BindingManager;
import hs.ddif.core.inject.store.BoundInstantiatorProvider;
import hs.ddif.core.instantiation.Instantiator;
import hs.ddif.core.instantiation.InstantiatorFactory;
import hs.ddif.core.instantiation.TypeTrait;
import hs.ddif.core.store.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InstantiatorBindingMap
implements BoundInstantiatorProvider,
BindingManager {
    private final Map<Binding, Reference<Instantiator<?>>> instantiators = new HashMap();
    private final InstantiatorFactory instantiatorFactory;

    public InstantiatorBindingMap(InstantiatorFactory instantiatorFactory) {
        this.instantiatorFactory = instantiatorFactory;
    }

    @Override
    public <T> Instantiator<T> getInstantiator(Binding binding) {
        Reference<Instantiator<?>> reference = this.instantiators.get(binding);
        if (reference == null) {
            return null;
        }
        Instantiator<?> referent = reference.getReferent();
        return referent;
    }

    @Override
    public Key getSearchKey(Binding binding) {
        return this.getInstantiator(binding).getKey();
    }

    @Override
    public Set<TypeTrait> getTypeTraits(Binding binding) {
        return this.getInstantiator(binding).getTypeTraits();
    }

    @Override
    public void addBinding(Binding binding) {
        Reference<Instantiator<?>> ref = this.instantiators.get(binding);
        if (ref == null) {
            this.instantiators.put(binding, new Reference(this.instantiatorFactory.getInstantiator(binding.getKey(), binding.getAnnotatedElement())));
        } else {
            ref.increaseReferences();
        }
    }

    @Override
    public void removeBinding(Binding binding) {
        Reference<Instantiator<?>> ref = this.instantiators.get(binding);
        if (ref == null) {
            throw new AssertionError((Object)("More bindings were removed than added: " + binding));
        }
        if (ref.decreaseReferences()) {
            this.instantiators.remove(binding);
        }
    }

    private static class Reference<T> {
        final T referent;
        int count = 1;

        Reference(T referent) {
            this.referent = referent;
        }

        T getReferent() {
            return this.referent;
        }

        void increaseReferences() {
            ++this.count;
        }

        boolean decreaseReferences() {
            return --this.count == 0;
        }
    }
}

