/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.instantiation;

import hs.ddif.core.instantiation.TypeExtension;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TypeExtensionStore {
    private final Map<Class<?>, TypeExtension<?>> typeExtensions;
    private final TypeExtension<?> defaultExtension;

    public TypeExtensionStore(TypeExtension<?> defaultExtension, Map<Class<?>, TypeExtension<?>> typeExtensions) {
        HashMap map = new HashMap();
        map.putAll(typeExtensions);
        this.typeExtensions = Collections.unmodifiableMap(map);
        this.defaultExtension = defaultExtension;
    }

    public Set<Class<?>> getExtendedTypes() {
        return this.typeExtensions.keySet();
    }

    public <T> TypeExtension<T> getExtension(Class<?> cls) {
        TypeExtension<?> extension = this.typeExtensions.get(cls);
        if (extension == null) {
            extension = this.defaultExtension;
        }
        TypeExtension<?> cast = extension;
        return cast;
    }
}

