/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.instantiation.factory;

import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.factory.LifeCycleCallbacks;
import hs.ddif.core.instantiation.injection.Constructable;
import hs.ddif.core.instantiation.injection.Injection;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassObjectFactory<T>
implements Constructable<T> {
    private static final Set<Object> UNDER_CONSTRUCTION = ConcurrentHashMap.newKeySet();
    private final Constructor<T> constructor;
    private final LifeCycleCallbacks lifeCycleCallbacks;

    public ClassObjectFactory(Constructor<T> constructor, LifeCycleCallbacks lifeCycleCallbacks) {
        this.constructor = Objects.requireNonNull(constructor, "constructor cannot be null");
        this.lifeCycleCallbacks = Objects.requireNonNull(lifeCycleCallbacks, "lifeCycleCallbacks cannot be null");
        constructor.setAccessible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(List<Injection> injections) throws InstanceCreationFailure {
        if (UNDER_CONSTRUCTION.contains(this)) {
            throw new InstanceCreationFailure(this.constructor.getDeclaringClass(), "already under construction (dependency creation loop in setter, initializer or post-construct method?)");
        }
        try {
            UNDER_CONSTRUCTION.add(this);
            T instance = this.constructInstance(injections);
            ClassObjectFactory.injectInstance(instance, injections);
            this.lifeCycleCallbacks.postConstruct(instance);
            T t = instance;
            return t;
        }
        finally {
            UNDER_CONSTRUCTION.remove(this);
        }
    }

    @Override
    public void destroy(T instance) {
        this.lifeCycleCallbacks.preDestroy(instance);
    }

    private T constructInstance(List<Injection> injections) throws InstanceCreationFailure {
        try {
            Object[] values = new Object[this.constructor.getParameterCount()];
            int parameterIndex = 0;
            for (Injection injection : injections) {
                if (injection.getTarget() != this.constructor) continue;
                values[parameterIndex++] = injection.getValue();
            }
            return this.constructor.newInstance(values);
        }
        catch (Exception e) {
            throw new InstanceCreationFailure(this.constructor, "call failed", (Throwable)e);
        }
    }

    private static void injectInstance(Object instance, List<Injection> injections) throws InstanceCreationFailure {
        Object[] values = null;
        int parameterIndex = 0;
        for (Injection injection : injections) {
            AccessibleObject accessibleObject = injection.getTarget();
            if (accessibleObject instanceof Field) {
                Field field = (Field)accessibleObject;
                try {
                    Object valueToSet = injection.getValue();
                    if (valueToSet == null) continue;
                    field.set(instance, valueToSet);
                    continue;
                }
                catch (Exception e) {
                    throw new InstanceCreationFailure(field, "inject failed", (Throwable)e);
                }
            }
            if (!(accessibleObject instanceof Method)) continue;
            Method method = (Method)accessibleObject;
            if (values == null) {
                values = new Object[method.getParameterCount()];
            }
            values[parameterIndex++] = injection.getValue();
            if (parameterIndex != method.getParameterCount()) continue;
            try {
                method.invoke(instance, values);
            }
            catch (Exception e) {
                throw new InstanceCreationFailure(method, "inject failed", (Throwable)e);
            }
            values = null;
            parameterIndex = 0;
        }
    }
}

