/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.instantiation.factory;

import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.injection.Constructable;
import hs.ddif.core.instantiation.injection.Injection;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

public class MethodObjectFactory<T>
implements Constructable<T> {
    private final Method method;
    private final boolean isStatic;

    public MethodObjectFactory(Method method) {
        this.method = method;
        this.isStatic = Modifier.isStatic(method.getModifiers());
        method.setAccessible(true);
    }

    @Override
    public T create(List<Injection> injections) throws InstanceCreationFailure {
        try {
            Object[] values = new Object[injections.size() - (this.isStatic ? 0 : 1)];
            Object instance = null;
            int parameterIndex = 0;
            for (Injection injection : injections) {
                if (injection.getTarget() instanceof Method) {
                    values[parameterIndex++] = injection.getValue();
                    continue;
                }
                instance = injection.getValue();
            }
            Object value = this.method.invoke(instance, values);
            return (T)value;
        }
        catch (Exception e) {
            throw new InstanceCreationFailure(this.method, "call failed", (Throwable)e);
        }
    }

    @Override
    public void destroy(T instance) {
    }
}

