/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.scope;

import hs.ddif.core.instantiation.injection.Constructable;
import hs.ddif.core.scope.InjectionContext;
import hs.ddif.core.scope.OutOfScopeException;
import hs.ddif.core.scope.ScopeResolver;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractScopeResolver<S>
implements ScopeResolver {
    private final Map<S, Map<Constructable<?>, ContextualInstance<?>>> instancesByScope = new HashMap();

    @Override
    public final boolean isActive() {
        return this.getCurrentScope() != null;
    }

    @Override
    public final <T> T get(Constructable<T> constructable, InjectionContext injectionContext) throws Exception {
        Object instance;
        S currentScope = this.getCurrentScope();
        if (currentScope == null) {
            throw new OutOfScopeException(constructable, this.getAnnotationClass());
        }
        Map instances = this.instancesByScope.computeIfAbsent(currentScope, k -> new HashMap());
        ContextualInstance contextualInstance = (ContextualInstance)instances.get(constructable);
        Object t = instance = contextualInstance == null ? null : (Object)contextualInstance.instance;
        if (instance == null) {
            instance = constructable.create(injectionContext.getInjections());
            instances.put(constructable, new ContextualInstance<Object>(instance, injectionContext));
        }
        return instance;
    }

    @Override
    public final <T> void remove(Constructable<T> constructable) {
        for (Map<Constructable<?>, ContextualInstance<?>> map : this.instancesByScope.values()) {
            ContextualInstance<?> contextualInstance = map.remove(constructable);
            if (contextualInstance == null) continue;
            contextualInstance.injectionContext.release();
        }
    }

    protected abstract S getCurrentScope();

    protected final void destroyScope(S scope) {
        Map<Constructable<?>, ContextualInstance<?>> instances = this.instancesByScope.remove(scope);
        if (instances != null) {
            for (ContextualInstance<?> contextualInstance : instances.values()) {
                contextualInstance.injectionContext.release();
            }
        }
    }

    private static class ContextualInstance<T> {
        final T instance;
        final InjectionContext injectionContext;

        ContextualInstance(T instance, InjectionContext injectionContext) {
            this.instance = instance;
            this.injectionContext = injectionContext;
        }
    }
}

