/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.scope;

import hs.ddif.core.instantiation.injection.Constructable;
import hs.ddif.core.scope.InjectionContext;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.scope.UnknownScopeException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class ScopeResolverManager {
    private final Map<Class<? extends Annotation>, ScopeResolver> scopeResolversByAnnotation = new HashMap<Class<? extends Annotation>, ScopeResolver>();

    public ScopeResolverManager(ScopeResolver ... scopeResolvers) {
        for (ScopeResolver scopeResolver : scopeResolvers) {
            this.scopeResolversByAnnotation.put(scopeResolver.getAnnotationClass(), scopeResolver);
        }
        this.scopeResolversByAnnotation.put(null, new NullScopeResolver());
    }

    public ScopeResolver getScopeResolver(Annotation scope) {
        ScopeResolver scopeResolver = this.scopeResolversByAnnotation.get(scope == null ? null : scope.annotationType());
        if (scopeResolver == null) {
            throw new UnknownScopeException("Unknown scope encountered: " + scope);
        }
        return scopeResolver;
    }

    private static class NullScopeResolver
    implements ScopeResolver {
        private NullScopeResolver() {
        }

        @Override
        public Class<? extends Annotation> getAnnotationClass() {
            return null;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public <T> T get(Constructable<T> constructable, InjectionContext injectionContext) throws Exception {
            return constructable.create(injectionContext.getInjections());
        }

        @Override
        public <T> void remove(Constructable<T> constructable) {
        }
    }
}

