/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.store;

import hs.ddif.core.util.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class Key {
    private final Set<Annotation> qualifiers;
    private final Type type;

    public Key(Type type, Collection<Annotation> qualifiers) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (qualifiers == null) {
            throw new IllegalArgumentException("qualifiers cannot be null");
        }
        this.type = Primitives.toBoxed(type);
        this.qualifiers = Collections.unmodifiableSet(new HashSet<Annotation>(qualifiers));
    }

    public Key(Type type) {
        this(type, Set.of());
    }

    public Type getType() {
        return this.type;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String toString() {
        return (String)(this.qualifiers.isEmpty() ? "" : this.qualifiers.stream().map(Object::toString).sorted().collect(Collectors.joining(" ")) + " ") + this.type.getTypeName();
    }

    public int hashCode() {
        return Objects.hash(this.type, this.qualifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Key other = (Key)obj;
        if (!this.qualifiers.equals(other.qualifiers)) {
            return false;
        }
        return this.type.equals(other.type);
    }
}

