/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.util;

import io.leangen.geantyref.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Annotations {
    public static <A extends Annotation> A of(Class<A> annotationClass, Map<String, Object> values) {
        try {
            return (A)TypeFactory.annotation(annotationClass, values);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert to annotation: " + annotationClass + " " + values, e);
        }
    }

    public static <A extends Annotation> A of(Class<A> annotationClass) {
        return Annotations.of(annotationClass, Map.of());
    }

    public static Set<Annotation> findAnnotations(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        HashSet<Annotation> matchingAnnotations = new HashSet<Annotation>();
        ArrayDeque<Annotation> annotations = new ArrayDeque<Annotation>();
        annotations.addAll(Arrays.asList(element.getAnnotations()));
        HashSet<Annotation> visited = new HashSet<Annotation>(annotations);
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            for (Annotation childAnnotation : annotation.annotationType().getAnnotations()) {
                if (!visited.add(childAnnotation)) continue;
                annotations.add(childAnnotation);
            }
            if (annotation.annotationType() != annotationType) continue;
            matchingAnnotations.add(annotation);
        }
        return matchingAnnotations;
    }

    public static Set<Annotation> findDirectlyMetaAnnotatedAnnotations(AnnotatedElement element, Annotation metaAnnotation) {
        HashSet<Annotation> matchingAnnotations = new HashSet<Annotation>();
        ArrayDeque<Annotation> annotations = new ArrayDeque<Annotation>();
        annotations.addAll(Arrays.asList(element.getAnnotations()));
        HashSet<Annotation> visited = new HashSet<Annotation>(annotations);
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            for (Annotation childAnnotation : annotation.annotationType().getAnnotations()) {
                if (visited.add(childAnnotation)) {
                    annotations.add(childAnnotation);
                }
                if (!childAnnotation.equals(metaAnnotation)) continue;
                matchingAnnotations.add(annotation);
            }
        }
        return matchingAnnotations;
    }

    public static Set<Annotation> findDirectlyMetaAnnotatedAnnotations(AnnotatedElement element, Class<? extends Annotation> metaAnnotation) {
        HashSet<Annotation> matchingAnnotations = new HashSet<Annotation>();
        ArrayDeque<Annotation> annotations = new ArrayDeque<Annotation>();
        annotations.addAll(Arrays.asList(element.getAnnotations()));
        HashSet<Annotation> visited = new HashSet<Annotation>(annotations);
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            for (Annotation childAnnotation : annotation.annotationType().getAnnotations()) {
                if (visited.add(childAnnotation)) {
                    annotations.add(childAnnotation);
                }
                if (!childAnnotation.annotationType().equals(metaAnnotation)) continue;
                matchingAnnotations.add(annotation);
            }
        }
        return matchingAnnotations;
    }

    public static List<Annotation> findMetaAnnotatedAnnotations(AnnotatedElement element, Annotation metaAnnotation) {
        return Stream.of(element.getAnnotations()).filter(annotation -> Annotations.isMetaAnnotated(annotation, metaAnnotation)).collect(Collectors.toList());
    }

    public static boolean isMetaAnnotated(Annotation annotation, Annotation metaAnnotation) {
        return Annotations.findAnnotations(annotation.annotationType(), metaAnnotation.annotationType()).contains(metaAnnotation);
    }
}

