/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;

public class Types {
    public static Set<Class<?>> getSuperTypes(Class<?> cls) {
        ArrayDeque toScan = new ArrayDeque();
        HashSet superTypes = new HashSet();
        toScan.add(cls);
        while (!toScan.isEmpty()) {
            Class scanClass = (Class)toScan.remove();
            superTypes.add(scanClass);
            for (Class<?> iface : scanClass.getInterfaces()) {
                toScan.add(iface);
            }
            if (scanClass.getSuperclass() == null) continue;
            toScan.add(scanClass.getSuperclass());
        }
        return superTypes;
    }

    public static ParameterizedType parameterize(Class<?> raw, Type ... typeArguments) {
        return TypeUtils.parameterize(raw, (Type[])typeArguments);
    }

    public static WildcardType wildcardExtends(Type ... upperBounds) {
        return TypeUtils.wildcardType().withUpperBounds(upperBounds).build();
    }

    public static <T> Class<T> raw(Type type) {
        return TypeUtils.getRawType((Type)type, null);
    }

    public static boolean containsTypeVariables(Type type) {
        return TypeUtils.containsTypeVariables((Type)type);
    }

    public static Type getTypeParameter(Type type, Class<?> cls, TypeVariable<?> typeVariable) {
        return (Type)TypeUtils.getTypeArguments((Type)type, cls).get(typeVariable);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
        return TypeUtils.getTypeArguments((Type)type, toClass);
    }

    public static Type resolveVariables(Map<TypeVariable<?>, Type> typeArguments, Type type) {
        return TypeUtils.unrollVariables(typeArguments, (Type)type);
    }

    public static boolean isAssignable(Type type, Type toType) {
        return TypeUtils.isAssignable((Type)type, (Type)toType);
    }

    public static Type[] getUpperBounds(WildcardType type) {
        return TypeUtils.getImplicitUpperBounds((WildcardType)type);
    }
}

