/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbbbbb.sso.filter;

import com.github.houbbbbb.sso.config.SSOFilterCNF;
import com.github.houbbbbb.sso.cons.SSOCON;
import com.github.houbbbbb.sso.util.CookieUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSOFilter
implements Filter {
    private SSOFilterCNF ssoFilterCNF;

    public SSOFilter(SSOFilterCNF ssoFilterCNF) {
        this.ssoFilterCNF = ssoFilterCNF;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if ("1".equals(this.ssoFilterCNF.getEnable())) {
            String method = request.getMethod();
            if ("GET".equals(method.toUpperCase())) {
                String token = CookieUtil.getCookie(request, "SSO_TOKEN");
                String backToken = request.getParameter("token");
                if (null != backToken) {
                    System.out.println("backToken : " + backToken);
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else if (null != token && SSOCON.userCacheMap.containsKey(token)) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else if (request.getRequestURI().endsWith(this.ssoFilterCNF.getPattern())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.ssoFilterCNF.getRedirectUrl()).append("/").append(this.ssoFilterCNF.getAppId()).append("/").append(this.ssoFilterCNF.getAppName());
                    response.sendRedirect(sb.toString());
                } else {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

