/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbbbbb.sso.secret;

import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SecretUtil {
    private static final String charset = "utf-8";
    private static final String AES = "AES";
    private static int keysizeAES = 128;

    public static String AESencode(String res, String key) {
        return SecretUtil.keyGeneratorES(res, AES, key, keysizeAES, true);
    }

    public static String AESdecode(String res, String key) {
        return SecretUtil.keyGeneratorES(res, AES, key, keysizeAES, false);
    }

    private static String keyGeneratorES(String res, String algorithm, String key, int keysize, boolean isEncode) {
        try {
            byte[] keyBytes;
            KeyGenerator kg = KeyGenerator.getInstance(algorithm);
            if (keysize == 0) {
                keyBytes = charset == null ? key.getBytes() : key.getBytes(charset);
                kg.init(new SecureRandom(keyBytes));
            } else if (key == null) {
                kg.init(keysize);
            } else {
                keyBytes = charset == null ? key.getBytes() : key.getBytes(charset);
                kg.init(keysize, new SecureRandom(keyBytes));
            }
            SecretKey sk = kg.generateKey();
            SecretKeySpec sks = new SecretKeySpec(sk.getEncoded(), algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (isEncode) {
                cipher.init(1, sks);
                byte[] resBytes = charset == null ? res.getBytes() : res.getBytes(charset);
                return SecretUtil.parseByte2HexStr(cipher.doFinal(resBytes));
            }
            cipher.init(2, sks);
            return new String(cipher.doFinal(SecretUtil.parseHexStr2Byte(res)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

