/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbbbbb.sso.cons;

import com.github.houbbbbb.sso.util.GsonUtil;
import com.github.houbbbbb.sso.util.SecretUtil;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SSOCON {
    private static final Map<String, JsonObject> userCacheMap = new ConcurrentHashMap();
    public static final String SSO_UTF_8 = "UTF-8";
    public static final String SSO_SESSION = "SSO_SESSION";

    public static void putUserCache(String key, JsonObject value) {
        if (null != key) {
            try {
                String userId = value.get("id").getAsString();
                String userInfo = value.get("userInfo").getAsString();
                userInfo = SecretUtil.decodeMix((String)userInfo, (String)userId);
                value = (JsonObject)GsonUtil.toObj((String)userInfo, JsonObject.class);
                userCacheMap.put(key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static JsonObject getUserCache(String key) {
        if (null != key) {
            return (JsonObject)userCacheMap.get(key);
        }
        return null;
    }

    public static boolean containsUserCache(String key) {
        if (null != key) {
            return userCacheMap.containsKey(key);
        }
        return false;
    }

    public static int userCacheSize() {
        return userCacheMap.size();
    }

    public static void removeUserCache(String key) {
        if (null != key) {
            userCacheMap.remove(key);
        }
    }

    public static void removeUserCacheAll() {
        userCacheMap.clear();
    }
}

