/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbbbbb.sso.filter;

import com.github.houbbbbb.sso.config.SSOFilterCNF;
import com.github.houbbbbb.sso.cons.SSOCON;
import com.github.houbbbbb.sso.util.CookieUtil;
import com.github.houbbbbb.sso.util.DateUtil;
import com.github.houbbbbb.sso.util.GsonUtil;
import com.github.houbbbbb.sso.util.HttpClientUtil;
import com.github.houbbbbb.sso.util.PostParam;
import com.github.houbbbbb.sso.util.SecretUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSOFilter
implements Filter {
    private SSOFilterCNF ssoFilterCNF;

    public SSOFilter(SSOFilterCNF ssoFilterCNF) {
        this.ssoFilterCNF = ssoFilterCNF;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if ("1".equals(this.ssoFilterCNF.getEnable())) {
            String method = request.getMethod();
            String session = CookieUtil.getCookie((HttpServletRequest)request, (String)"SSO_SESSION");
            String uri = request.getRequestURI();
            if ("GET".equals(method.toUpperCase())) {
                if (this.matchPattern(uri)) {
                    if (null != session) {
                        if (SSOCON.containsUserCache((String)session)) {
                            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                        } else {
                            String split = "/";
                            if (session.contains(split)) {
                                String[] ss = session.split(split);
                                if (ss.length == 2) {
                                    String domainId = ss[0];
                                    if (domainId.equals(this.ssoFilterCNF.getDomainId())) {
                                        String sessionId = ss[1];
                                        String param = SecretUtil.encodeMix((String)session, (String)sessionId);
                                        PostParam postParam = new PostParam();
                                        postParam.add("param", param);
                                        StringBuilder sb = new StringBuilder();
                                        sb.append(this.ssoFilterCNF.getInnerUrl()).append("/").append("back").append("/").append(this.ssoFilterCNF.getAppId()).append("/").append(session);
                                        String url = sb.toString();
                                        String re = HttpClientUtil.post((String)url, (PostParam)postParam);
                                        JsonObject user = (JsonObject)GsonUtil.toObj((String)re, JsonObject.class);
                                        if (null != user) {
                                            JsonElement o = user.get("userInfo");
                                            if (null != o) {
                                                SSOCON.putUserCache((String)session, (JsonObject)user);
                                                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                                            } else {
                                                String redUrl = user.get("permission").getAsString();
                                                StringBuilder sb2 = new StringBuilder();
                                                sb2.append(redUrl).append("?timestamp=").append(DateUtil.getTimestamp());
                                                response.sendRedirect(sb2.toString());
                                            }
                                        } else {
                                            this.noSessionDo(response);
                                        }
                                    } else {
                                        this.noSessionDo(response);
                                    }
                                } else {
                                    this.noSessionDo(response);
                                }
                            } else {
                                this.noSessionDo(response);
                            }
                        }
                    } else {
                        this.noSessionDo(response);
                    }
                } else {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void noSessionDo(HttpServletResponse response) throws IOException, ServletException {
        this.filterImpl(response);
    }

    private void filterImpl(HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ssoFilterCNF.getUrl()).append("/").append("red").append("/").append(this.ssoFilterCNF.getDomainId()).append("/").append(this.ssoFilterCNF.getAppId()).append("?timestamp=").append(DateUtil.getTimestamp());
        String url = sb.toString();
        response.sendRedirect(url);
    }

    private boolean matchPattern(String uri) {
        return null != uri && (uri.endsWith("*") && uri.startsWith(this.ssoFilterCNF.getPattern()) || uri.equals(this.ssoFilterCNF.getPattern()));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

