/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbbbbb.sso.service;

import com.github.houbbbbb.sso.config.SSOFilterCNF;
import com.github.houbbbbb.sso.cons.SSOCON;
import com.github.houbbbbb.sso.util.CookieUtil;
import com.github.houbbbbb.sso.util.DateUtil;
import com.google.gson.JsonObject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserOpt {
    private SSOFilterCNF ssoFilterCNF;

    public UserOpt(SSOFilterCNF ssoFilterCNF) {
        this.ssoFilterCNF = ssoFilterCNF;
    }

    public JsonObject getUser(HttpServletRequest request) {
        String session = CookieUtil.getCookie((HttpServletRequest)request, (String)"SSO_SESSION");
        return SSOCON.getUserCache((String)session);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        try {
            String session = this.sessionHandle(request);
            StringBuilder sb = new StringBuilder();
            sb.append(this.ssoFilterCNF.getUrl()).append("/logout").append("/").append(this.ssoFilterCNF.getAppId()).append("/").append(session).append("?timestamp=").append(DateUtil.getTimestamp());
            String url = sb.toString();
            response.sendRedirect(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String sessionHandle(HttpServletRequest request) {
        String session = CookieUtil.getCookie((HttpServletRequest)request, (String)"SSO_SESSION");
        SSOCON.removeUserCache((String)session);
        return session;
    }
}

