package com.github.houbbbbb.sso.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * @author : hbw
 * @desctiption :
 * @date : 2020-05-15 10:03
 */
@Setter
@ConfigurationProperties(prefix = "ssop")
public class SSOPFilterConfig {
    /** 以下为网络相关配置 */

    /**
     * 客户端端口号
     */
    private String clientPort = "8080";

    /**
     * 服务类型，client - 客户端， server - 服务器， all - 两者都有
     * 默认 client
     */
    private String type = "client";

    /**
     * 服务器地址，默认 127.0.0.1
     */
    private String serverHost = "127.0.0.1";

    /**
     * 服务器端口号，默认9990
     */
    private String serverPort = "9990";

    /**
     * 缓存存活时间，默认两小时，7200000
     */
    private String cacheTimedOut = "7200000";

    /**
     * 客户端重启时间，默认1分钟，60000
     */
    private String clientRetryTime = "60000";

    /**
     * 客户端重启次数，默认如果没有链接到服务器，则一直重启
     */
    private String clientRetryTimes = "-1";

    /**
     * 心跳检测时间，默认两秒，2000
     */
    private String tickTime = "2000";

    /**
     * 心跳超时时间，默认10秒钟，10000
     */
    private String tickTimedOut = "10000";

    /**
     * 心跳超时次数，默认3次，2
     */
    private String tickTimedOutTimes = "2";


    /** 以下为单点相关配置 */

    /**
     * 是否启用单点登录，默认 false
     */
    private String enabled = "false";

    /**
     * 单点校验规则，默认路径，/auth
     */
    private String pattern = "/auth";

    /**
     * 单点登出
     */
    private String logout = "/logout";

    /**
     * 单点代理的serviceId，默认，空
     */
    private String ssoServiceId = "";

    /** 以下为 app 相关配置 */

    /**
     * app 名称
     */
    private String appName = "app";

    /**
     * app 类型
     */
    private String appType = "type";

    /**
     * app 的 serviceId
     */
    private String serviceId = "";

    /**
     * 用户登录超时时间 默认2小时，7200000
     */
    private String loginTimedout = "7200000";

    /**
     * 不过滤的路径
     */
    private List<String> external;

    public List<String> getExternal() {
        return external;
    }

    public String getLogout() {
        return logout;
    }

    public Long getLoginTimedout () {
        return Long.valueOf(loginTimedout);
    }

    public String getType() {
        return type;
    }

    public String getServerHost() {
        return serverHost;
    }

    public Integer getServerPort() {
        return Integer.valueOf(serverPort);
    }

    public Long getCacheTimedOut() {
        return Long.valueOf(cacheTimedOut);
    }

    public Long getTickTime() {
        return Long.valueOf(tickTime);
    }

    public Long getClientRetryTime() {
        return Long.valueOf(clientRetryTime);
    }

    public Integer getClientRetryTimes() {
        return Integer.valueOf(clientRetryTimes);
    }

    public Long getTickTimedOut() {
        return Long.valueOf(tickTimedOut);
    }

    public Integer getTickTimedOutTimes() {
        return Integer.valueOf(tickTimedOutTimes);
    }

    public Boolean getEnabled() {
        return Boolean.valueOf(enabled);
    }

    public String getPattern() {
        return pattern;
    }

    public String getSsoServiceId() {
        return ssoServiceId;
    }

    public String getAppName() {
        return appName;
    }

    public String getAppType() {
        return appType;
    }

    public String getServiceId() {
        return serviceId;
    }

    public Integer getClientPort() {
        return Integer.valueOf(clientPort);
    }
}
