package com.github.houbbbbb.sso.entity;

import com.github.houbbbbb.sso.nt.util.DebugUtil;
import com.github.houbbbbb.sso.util.SecretUtil;
import lombok.Getter;
import lombok.ToString;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/17
 **/
public class SSOPUserDTO {
    private String key = "ssopUserInfo";
    private String id;
    private String user;
    private String permission;

    public SSOPUserDTO setPermission (Boolean permission) {
        this.permission = String.valueOf(permission);
        return this;
    }

    public Boolean getPermission () {
        return Boolean.valueOf(permission);
    }

    private SSOPUserDTO () {}

    public static SSOPUserDTO create () {
        return new SSOPUserDTO();
    }

    public SSOPUserDTO setId(String id) {
        this.id = SecretUtil.encodeMix(id, key);
        return this;
    }

    public SSOPUserDTO setUser(String user, String id) {
        this.user = SecretUtil.encodeMix(user, id);
        return this;
    }

    public String getId() {
        return SecretUtil.decodeMix(id, key);
    }

    public String getUser () {
        return SecretUtil.decodeMix(user, getId());
    }

    @Override
    public String toString() {
        return "SSOPUserDTO{" +
                "key='" + key + '\'' +
                ", id='" + id + '\'' +
                ", user='" + user + '\'' +
                '}';
    }
}
