package com.github.houbbbbb.sso.nt.constants;

import com.github.houbbbbb.sso.nt.entity.AppDTO;
import org.springframework.cache.concurrent.ConcurrentMapCache;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/10
 **/
public class CacheConstants {

    /**
     * 服务端
     */
    /**
     * 记录超时时间
      */
    public static final Map<String, String> LINK_CACHE = new ConcurrentHashMap<>(16);
    /**
     * 记录当前app信息
     */
    public static final Map<String, AppDTO> INFO_CACHE = new ConcurrentHashMap<>(16);
    /**
     * 记录数量变化，为每一个key记录一次，以保证统一
     */
    public static volatile Map<String, Integer> LINK_COUNT = new ConcurrentHashMap<>(16);

    /**
     * 下线同步记录
     */
    public static final Map<String, Set<String>> UPDATE_CACHE = new ConcurrentHashMap<>(16);

    /**
     * 客户端
     */
    public static final LinkedBlockingDeque<String> QUEUE_CACHE = new LinkedBlockingDeque<>(5000);
    public static final Map<String, List<AppDTO>> APP_CACHE = new ConcurrentHashMap<>(1);
    public static final String CLIENT_APP = "clientApp";
    /**
     * 登出清理缓存,实现即时登出功能
     */
    public static final LinkedBlockingQueue<String> CLEAR_CACHE = new LinkedBlockingQueue<>(500);

}
