package com.github.houbbbbb.sso.nt.factory;

import com.github.houbbbbb.sso.nt.filter.NetFilter;
import com.github.houbbbbb.sso.nt.handler.ClientChannelHandler;
import com.github.houbbbbb.sso.nt.handler.ServerChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.socket.SocketChannel;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/7
 **/
public interface Factory {
    /**
     * 获取ChannelInitializer
     * @param type
     * @return
     */
    ChannelInitializer<SocketChannel> getInitializer(ItemType type);

    /**
     * 获取ServerChannelHandler
     * @param type
     * @return
     */
    ServerChannelHandler getServerHandler(ItemType type);

    /**
     * 获取ClientChannelHandler
     * @param type
     * @return
     */
    ClientChannelHandler getClientHandler(ItemType type);

    /**
     * 获取线程池
     * @param type
     * @return
     */
    ThreadPoolExecutor getThread(ItemType type);

    /**
     * 获取编码器
     * @param type
     * @return
     */
    ChannelOutboundHandlerAdapter getEncoder (ItemType type);

    /**
     * 获取解码器
     * @param type
     * @return
     */
    ChannelInboundHandlerAdapter getDecoder (ItemType type);
}
