package com.github.houbbbbb.sso.nt.filter;

import com.github.houbbbbb.sso.nt.entity.AppDTO;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class SsoServiceIdFilter implements NetFilter {
    private String ssoServiceId;
    public SsoServiceIdFilter (String ssoServiceId) {
        this.ssoServiceId = ssoServiceId;
    }

    @Override
    public List<AppDTO> filter(List<AppDTO> appDTOS) {
        return appDTOS.stream().filter(appDTO -> ssoServiceId.equals(appDTO.getSsoServiceId())).collect(Collectors.toList());
    }
}
