package com.github.houbbbbb.sso.nt.loadbalance;

import java.util.*;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class Consistance {
    public static final Integer NODE_COUNT = 100;
    private static final Map<String, Consistance> MAP;
    static {
        MAP = new HashMap<>(16);
    }

    private Hash hash;
    private TreeMap<Long, String> treeMap;
    private Set<String> set;
    private Consistance () {
        this.hash = new Hash();
        this.treeMap = new TreeMap<>();
        this.set = new HashSet<>(16);
    }

    public Boolean contains (String ip) {
        return set.contains(ip);
    }

    public static Consistance create (String serviceId) {
        if (!MAP.containsKey(serviceId)) {
            MAP.put(serviceId, new Consistance());
        }
        return MAP.get(serviceId);
    }

    public void put (String ip) {
        synchronized (this) {
            set.add(ip);
            for (int i = 0; i < NODE_COUNT; i++) {
                treeMap.put(hash.hash((ip + i)), ip);
            }
        }
    }

    public String keyLoadBalance(String key){
        return get(hash.hash(key));
    }

    public String selfLoadBalance () {
        return get(hash.hash(UUID.randomUUID().toString()));
    }

    public String get (Long key) {
        synchronized (this) {
            if (treeMap.containsKey(key)) {
                return treeMap.get(key);
            }
            if (treeMap.size() > 0) {
                SortedMap<Long, String> tailMap = treeMap.tailMap(key);
                key = tailMap.isEmpty() ? treeMap.firstKey() : tailMap.firstKey();
                return treeMap.get(key);
            }
            return null;
        }
    }

    public void remove (String ip) {
        synchronized (this) {
            set.remove(ip);
            for (int i = 0; i < NODE_COUNT; i++) {
                treeMap.remove(hash.hash((ip + i)));
            }
        }
    }

    public Set<String> getIps () {
        return set;
    }
}
