package com.github.houbbbbb.sso.nt.opt;

import com.github.houbbbbb.sso.entity.AppDO;
import com.github.houbbbbb.sso.nt.constants.CacheConstants;
import com.github.houbbbbb.sso.nt.filter.*;
import com.github.houbbbbb.sso.nt.entity.AppDTO;
import com.github.houbbbbb.sso.nt.loadbalance.Consistance;
import com.github.houbbbbb.sso.nt.util.AppConvertUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/13
 **/
public class ClientOpt {

    public static List<AppDTO> getAppInfo () {
        if (CacheConstants.APP_CACHE.containsKey(CacheConstants.CLIENT_APP)) {
            return CacheConstants.APP_CACHE.get(CacheConstants.CLIENT_APP);
        }
        return new ArrayList<>();
    }

    public static List<AppDTO> getAppByServiceIdTypeName (String serviceId, String type, String name) {
        return new AndFilter(new ServiceIdFilter(serviceId), new AndFilter(new NameFilter(name), new TypeFilter(type))).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceId (String serviceId) {
        return new ServiceIdFilter(serviceId).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByName (String name) {
        return new NameFilter(name).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByType (String type) {
        return new TypeFilter(type).filter(getAppInfo());
    }

    public static List<AppDTO> getAppBySsoServiceId (String ssoServiceId) {
        return new SsoServiceIdFilter(ssoServiceId).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceIdNot (String serviceId) {
        return new NotFilter(new ServiceIdFilter(serviceId)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByNameNot (String name) {
        return new NotFilter(new NameFilter(name)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByTypeNot (String type) {
        return new NotFilter(new TypeFilter(type)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppBySsoServiceIdNot (String ssoServiceId) {
        return new NotFilter(new SsoServiceIdFilter(ssoServiceId)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceIdAndName (String serviceId, String name) {
        return new AndFilter(new ServiceIdFilter(serviceId), new NameFilter(name)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceIdOrName (String serviceId, String name) {
        return new OrFilter(new ServiceIdFilter(serviceId), new NameFilter(name)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceIdAndType (String serviceId, String type) {
        return new AndFilter(new ServiceIdFilter(serviceId), new TypeFilter(type)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceIdOrType (String serviceId, String type) {
        return new OrFilter(new ServiceIdFilter(serviceId), new TypeFilter(type)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByNameAndType (String name, String type) {
        return new AndFilter(new NameFilter(name), new TypeFilter(type)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByNameOrType (String name, String type) {
        return new OrFilter(new NameFilter(name), new TypeFilter(type)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppBySsoServiceIdAndName (String ssoServiceId, String name) {
        return new AndFilter(new SsoServiceIdFilter(ssoServiceId), new NameFilter(name)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppBySsoServiceIdOrName (String ssoServiceId, String name) {
        return new OrFilter(new SsoServiceIdFilter(ssoServiceId), new NameFilter(name)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppBySsoServiceIdAndType (String ssoServiceId, String type) {
        return new AndFilter(new SsoServiceIdFilter(ssoServiceId), new TypeFilter(type)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppBySsoServiceIdOrType (String ssoServiceId, String type) {
        return new OrFilter(new SsoServiceIdFilter(ssoServiceId), new TypeFilter(type)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceIdAndSsoServiceId (String serviceId, String ssoServiceId) {
        return new AndFilter(new ServiceIdFilter(serviceId), new SsoServiceIdFilter(ssoServiceId)).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceIdOrSsoServiceId (String serviceId, String ssoServiceId) {
        return new OrFilter(new ServiceIdFilter(serviceId), new SsoServiceIdFilter(ssoServiceId)).filter(getAppInfo());
    }

    public static String getAppIpByServiceIdLoadBalanced (String serviceId) {
        if (null != Consistance.create(serviceId)) {
            return Consistance.create(serviceId).selfLoadBalance();
        }
        return null;
    }

    public static String getAppHostByServiceIdLoadBalanced (String serviceId) {
        String ipAddr = getAppIpByServiceIdLoadBalanced(serviceId);
        if (null != ipAddr) {
            List<AppDO> appDOS = AppConvertUtil.convert(getAppByServiceId(serviceId));
            if (null != appDOS && appDOS.size() > 0) {
                if (appDOS.size() == 1) {
                    return appDOS.get(0).getHostAddr();
                } else {
                    List<AppDO> appDOList = appDOS.stream().filter(appDO -> ipAddr.equals(appDO.getIpAddr())).collect(Collectors.toList());
                    if (appDOList.size() > 0) {
                        return appDOList.get(0).getHostAddr();
                    }
                }
            }
        }
        return null;
    }

    public static String getAppIpByServiceIdLoadBalanced (String serviceId, String key) {
        if (null != Consistance.create(serviceId)) {
            return Consistance.create(serviceId).keyLoadBalance(key);
        }
        return null;
    }

    public static String getAppHostByServiceIdLoadBalanced (String serviceId, String key) {
        String ipAddr = getAppIpByServiceIdLoadBalanced(serviceId, key);
        if (null != ipAddr) {
            List<AppDO> appDOS = AppConvertUtil.convert(getAppByServiceId(serviceId));
            if (null != appDOS && appDOS.size() > 0) {
                if (appDOS.size() == 1) {
                    return appDOS.get(0).getHostAddr();
                } else {
                    List<AppDO> appDOList = appDOS.stream().filter(appDO -> ipAddr.equals(appDO.getIpAddr())).collect(Collectors.toList());
                    if (appDOList.size() > 0) {
                        return appDOList.get(0).getHostAddr();
                    }
                }
            }
        }
        return null;
    }
}
