package com.github.houbbbbb.sso.nt.opt;

import com.github.houbbbbb.sso.nt.constants.CacheConstants;
import com.github.houbbbbb.sso.nt.entity.AppDTO;
import com.github.houbbbbb.sso.nt.filter.NameFilter;
import com.github.houbbbbb.sso.nt.filter.NotFilter;
import com.github.houbbbbb.sso.nt.filter.ServiceIdFilter;
import com.github.houbbbbb.sso.nt.filter.TypeFilter;

import java.util.ArrayList;
import java.util.List;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class ServerOpt {
    public static List<AppDTO> getAppInfo () {
        List<AppDTO> appDTOS = new ArrayList<>();
        CacheConstants.LINK_CACHE.forEach((a, b) -> {
            AppDTO appDTO = CacheConstants.INFO_CACHE.get(a);
            if (null != appDTO) {
                appDTOS.add(appDTO);
            }
        });
        return appDTOS;
    }

    public static List<AppDTO> getAppByType (String type) {
        return new TypeFilter(type).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByName (String name) {
        return new NameFilter(name).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByServiceId (String serviceId) {
        return new ServiceIdFilter(serviceId).filter(getAppInfo());
    }

    public static List<AppDTO> getAppByTypeNot (String type) {
        return new NotFilter(new TypeFilter(type)).filter(getAppInfo());
    }
}
