package com.github.houbbbbb.sso.nt.template;

import com.github.houbbbbb.sso.nt.constants.SwitchConstants;
import com.github.houbbbbb.sso.nt.factory.ItemType;
import com.github.houbbbbb.sso.nt.factory.StaticFactory;
import com.github.houbbbbb.sso.nt.util.DebugUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

import java.net.InetSocketAddress;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/7
 **/
public class ClientTemplate implements NettyTemplate {
    private String host;
    private Integer port;
    public ClientTemplate (String host, Integer port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void run () {
        EventLoopGroup eg = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            b.group(eg)
                    .channel(NioSocketChannel.class)
                    .option(ChannelOption.TCP_NODELAY, true)
                    .handler(StaticFactory.getInitializer(ItemType.CLIENT_INITIALIZER));
            ChannelFuture f = b.connect(host, port).sync();
            DebugUtil.debug("连接成功", host + " : " + port);
            DebugUtil.info("连接成功", host + " : " + port);
            f.channel().closeFuture().sync();
        } catch (Exception e) {
            SwitchConstants.clientStatus = true;
            DebugUtil.debug("exception：重连失败", host + " : " + port);
            DebugUtil.warn("exception：重连失败", host + " : " + port);
        } finally {
            eg.shutdownGracefully();
        }
    }
}
