package com.github.houbbbbb.sso.nt.template;

import com.github.houbbbbb.sso.nt.factory.ItemType;
import com.github.houbbbbb.sso.nt.factory.StaticFactory;
import com.github.houbbbbb.sso.nt.util.DebugUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/7
 **/
public class ServerTemplate implements NettyTemplate {
    public static final int SO_BACKLOG_VALUE = 100;
    private Integer port;
    public ServerTemplate (Integer port) {
        this.port = port;
    }

    @Override
    public void run () {
        EventLoopGroup boss = new NioEventLoopGroup();
        EventLoopGroup worker = new NioEventLoopGroup();
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(boss, worker)
                    .channel(NioServerSocketChannel.class)
                    .childHandler(StaticFactory.getInitializer(ItemType.SERVER_INITIALIZER))
                    .option(ChannelOption.SO_BACKLOG, SO_BACKLOG_VALUE)
                    .childOption(ChannelOption.SO_KEEPALIVE, true);
            ChannelFuture cf = sb.bind(port).sync();

            DebugUtil.debug("服务器启动成功", port);
            DebugUtil.info("服务器启动成功", port);

            cf.channel().closeFuture().sync();
        } catch (Exception e) {e.printStackTrace();} finally {
            worker.shutdownGracefully();
            boss.shutdownGracefully();
        }
    }
}
