package com.github.houbbbbb.sso.nt.util;

import com.github.houbbbbb.sso.entity.AppDO;
import com.github.houbbbbb.sso.nt.entity.AppDTO;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class AppConvertUtil {

    public static final String COLON = ":";

    private AppConvertUtil () {}

    public static List<AppDO> convert (List<AppDTO> appDTOS) {
        return appDTOS.stream().map(appDTO -> 
                AppDO.create().setAppName(appDTO.getAppName()).setAppType(appDTO.getAppType())
                        .setServiceId(appDTO.getServiceId()).setSsoServiceId(appDTO.getSsoServiceId())
                        .setHostAddr(appDTO.getHostName()+ COLON +appDTO.getPort())
                        .setIpAddr(appDTO.getIp()+COLON+appDTO.getPort()).setPattern(appDTO.getPattern())
        ).collect(Collectors.toList());
    }
}
