package com.github.houbbbbb.sso.nt.util;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/14
 **/
public class DebugUtil {
    public static volatile Boolean debug = false;
    public static volatile Boolean info = true;
    public static volatile Boolean warn = true;
    public static volatile Boolean trace = false;


    public static void debug (String key, Object value) {
        if (debug) {
            common(Level.DEBUG, key, value);
        }
    }

    public static void trace (String key, Object value) {
        if (trace) {
            common(Level.TRACE, key, value);
        }
    }

    public static void info (String key, Object value) {
        if (info) {
            common(Level.INFO, key, value);
        }
    }

    public static void warn (String key, String value) {
        if (warn) {
            common(Level.WARN, key, value);
        }
    }

    private static class Level {
        private static final String DEBUG = "debug";
        private static final String INFO = "info";
        private static final String WARN = "warn";
        private static final String TRACE = "trace";
    }

    private static void common (String level, String key, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(level).append("]").append(" ").append(System.currentTimeMillis())
                .append(" ").append(key).append(" --- ").append(value);
        System.out.println(sb.toString());
    }
}
