package com.github.houbbbbb.sso.scheduler;

import com.github.houbbbbb.sso.config.SSOPFilterConfig;
import com.github.houbbbbb.sso.cons.SSOPCacheConstants;
import com.github.houbbbbb.sso.cons.SSOPConstants;

import java.util.concurrent.TimeUnit;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/14
 **/
public class CacheClearJob implements Job {
    private static final Integer INI_DELAY = 0;

    private String type;
    private Long timedOut;
    private Boolean enabled;
    public CacheClearJob (SSOPFilterConfig ssopFilterConfig) {
        this.type = ssopFilterConfig.getType();
        this.timedOut = ssopFilterConfig.getCacheTimedOut();
        this.enabled = ssopFilterConfig.getEnabled();
    }

    @Override
    public void run() {
        cacheClear();
    }

    /**
     * 缓存清理
     */
    public void cacheClear () {
        try {
            if (TypeJudge.client(type, enabled)) {
                Scheduler.getScheduler(Scheduler.Type.CACHE_CLEAR).scheduleAtFixedRate(
                        SSOPCacheConstants.SSO_CACHE::clear, INI_DELAY, timedOut, TimeUnit.MILLISECONDS);
            }
        } catch (Exception e) {e.printStackTrace();}
    }
}
