package com.github.houbbbbb.sso.scheduler;

import com.github.houbbbbb.sso.config.SSOPFilterConfig;
import com.github.houbbbbb.sso.cons.SSOPConstants;
import com.github.houbbbbb.sso.nt.constants.CacheConstants;
import com.github.houbbbbb.sso.nt.entity.AppDTO;
import com.github.houbbbbb.sso.nt.loadbalance.Consistance;
import com.github.houbbbbb.sso.nt.opt.ClientOpt;
import com.github.houbbbbb.sso.nt.util.AppConvertUtil;
import com.github.houbbbbb.sso.nt.util.DebugUtil;
import com.github.houbbbbb.sso.util.GsonUtil;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class ClientCheckJob implements Job {
    private static final Integer INI_DELAY = 0;
    private String type;
    private Long tick;
    private Boolean enabled;
    public ClientCheckJob (SSOPFilterConfig ssopFilterConfig) {
        this.type = ssopFilterConfig.getType();
        this.tick = ssopFilterConfig.getTickTime();
        this.enabled = ssopFilterConfig.getEnabled();
    }

    @Override
    public void run () {
        if (TypeJudge.client(type, enabled)) {
            Scheduler.getScheduler(Scheduler.Type.CLIENT_CHECK).scheduleWithFixedDelay(() -> {
                if (CacheConstants.QUEUE_CACHE.size() > 0) {
                    DebugUtil.debug("client check", CacheConstants.QUEUE_CACHE);
                    String str = CacheConstants.QUEUE_CACHE.pollLast();
                    CacheConstants.QUEUE_CACHE.clear();
                    try {
                        List<AppDTO> appDTOS = (List<AppDTO>) GsonUtil.toObj(str, List.class).stream().map(o ->
                            GsonUtil.toObj(GsonUtil.toJson(o), AppDTO.class)
                        ).collect(Collectors.toList());
                        CacheConstants.APP_CACHE.put(CacheConstants.CLIENT_APP, appDTOS);
                        List<String> serviceIds = appDTOS.stream().map(AppDTO::getServiceId).collect(Collectors.toList());
                        loadBalanceSync(serviceIds);
                    } catch (Exception e) {e.printStackTrace();}
                }
            }, INI_DELAY, tick, TimeUnit.MILLISECONDS);
        }
    }

    private void loadBalanceSync (List<String> serviceIds) {
        serviceIds.forEach(serviceId -> {
            List<String> ips = AppConvertUtil.convert(ClientOpt.getAppByServiceId(serviceId)).stream().map(appDO -> appDO.getIpAddr())
                    .collect(Collectors.toList());
            Consistance consistance = Consistance.create(serviceId);
            consistance.getIps().stream().filter(s -> !ips.contains(s)).collect(Collectors.toList())
                    .forEach(consistance::remove);
            ips.stream().filter(s -> !consistance.contains(s)).collect(Collectors.toList())
                    .forEach(consistance::put);
        });
    }
}
