package com.github.houbbbbb.sso.scheduler;

import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

/**
 * @author : hbw
 * @desctiption :
 * @date : 2020-06-23 14:20
 */
public class Scheduler {
    private static final Integer CORE_SIZE = 1;

    public static ScheduledThreadPoolExecutor getScheduler (Type type) {
        String poolName = null;
        switch (type) {
            case CACHE_CLEAR: poolName = "cache-clear-pool-"; break;
            case SERVER_CHECK: poolName = "server-check-pool-"; break;
            case CLIENT_RESTART: poolName = "client-restart-pool-"; break;
            case CLIENT_CHECK: poolName = "client-check-pool-"; break;
            default: break;
        }
        ThreadFactory factory = new CustomizableThreadFactory(poolName);
        return new ScheduledThreadPoolExecutor(CORE_SIZE, factory);
    }

    enum Type {
        /**
         * 清除缓存
         */
        CACHE_CLEAR,
        /**
         * 心跳检测
         */
        SERVER_CHECK,
        /**
         * 客户端重启
         */
        CLIENT_RESTART,
        /**
         * 客户端检测
         */
        CLIENT_CHECK,
    }

}
