package com.github.houbbbbb.sso.service;

import com.github.houbbbbb.sso.config.SSOPFilterConfig;
import com.github.houbbbbb.sso.cons.SSOPCacheConstants;
import com.github.houbbbbb.sso.cons.SSOPConstants;
import com.github.houbbbbb.sso.nt.opt.CacheOpt;
import com.github.houbbbbb.sso.nt.opt.ClientOpt;
import com.github.houbbbbb.sso.util.CookieUtil;
import com.github.houbbbbb.sso.util.HttpClientUtil;
import com.github.houbbbbb.sso.util.PostParam;
import com.github.houbbbbb.sso.util.ThreadLocalUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class SSOPUserService {
    private String ssoServiceId;
    private String serviceId;
    private Handler handler;
    private String logout;
    public SSOPUserService (SSOPFilterConfig ssopFilterConfig) {
        this.ssoServiceId = ssopFilterConfig.getSsoServiceId();
        this.serviceId = ssopFilterConfig.getServiceId();
        this.logout = ssopFilterConfig.getLogout();
        handler = new Handler();
    }

    public void logout (HttpServletRequest request, HttpServletResponse response, Boolean local) {
        handler.logout(request, response, local);
    }

    public String getUserInfo (HttpServletRequest request) {
        return handler.getUser(request);
    }

    public String getPerms(String userId) {
        return handler.getPerms(userId);
    }

    private class Handler {

        private String getUrl() {
            StringBuilder sb = new StringBuilder();
            sb.append(SSOPConstants.HTTP).append(getIpAddr()).append(SSOPConstants.LOGOUT);
            return sb.toString();
        }

        private String getHostUrl () {
            StringBuilder sb = new StringBuilder();
            sb.append(SSOPConstants.HTTP).append(getHostAddr()).append(SSOPConstants.LOGOUT);
            return sb.toString();
        }

        private String getIpAddr() {
            return ClientOpt.getAppIpByServiceIdLoadBalanced(ssoServiceId, ssoServiceId);
        }

        private String getHostAddr () {
            return ClientOpt.getAppHostByServiceIdLoadBalanced(ssoServiceId, ssoServiceId);
        }

        private String getSession() {
            return serviceId + SSOPConstants.SESSION;
        }

        private String getSession(HttpServletRequest request) {
            return CookieUtil.getCookie(request, getSession());
        }

        public void logout (HttpServletRequest request, HttpServletResponse response, Boolean local) {
            String sessionId = getSession(request);
            SSOPCacheConstants.SSO_CACHE.remove(sessionId);
            CacheOpt.offer(sessionId);
            if (local) {
                HttpClientUtil.post(getUrl(), getParam(request));
            } else {
                remoteRedirect(request, response);
            }
        }

        private void remoteRedirect (HttpServletRequest request, HttpServletResponse response) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(getHostUrl())
                        .append("?session=").append(getSession(request))
                        .append("&logoutUrl=").append(getLogoutUrl(request));
                response.sendRedirect(sb.toString());
            } catch (Exception e) {e.printStackTrace();}
        }

        private String getLogoutUrl (HttpServletRequest request) {
            String url = request.getRequestURL().toString();
            String scheme = url.substring(0, url.indexOf("://")+3);
            String other = url.replace(scheme, "");
            String host = other.substring(0, other.indexOf("/"));
            StringBuilder sb = new StringBuilder();
            sb.append(scheme).append(host).append(logout);
            return sb.toString();
        }

        private PostParam getParam (HttpServletRequest request) {
            PostParam param = new PostParam();
            param.add("session", getSession(request));
            return param;
        }

        private String getUser (HttpServletRequest request) {
            String user = ThreadLocalUtil.get();
            if (null == user) {
                return SSOPCacheConstants.SSO_CACHE.get(getSession(request));
            } else {
                return user;
            }
        }

        private String getPerms (String userId) {
            StringBuilder sb = new StringBuilder();
            sb.append(SSOPConstants.HTTP).append(getIpAddr())
                    .append("/info/perms/").append(userId);
            String url = sb.toString();
            return HttpClientUtil.post(url, null);
        }
    }
}
