package com.github.houbbbbb.sso.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author : hbw
 * @desctiption :
 * @date : 2020-05-18 15:55
 */
public class CookieUtil {

    public static void setCookie(HttpServletResponse response,
                                 String name, String value, String host){
        Cookie cookie = new Cookie(name, value);
        if(null!=host) {
            cookie.setDomain(host.substring(host.indexOf(".") + 1));
        }
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static void setCookie(HttpServletResponse response,
                                 String name, String value){
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static String getCookie(HttpServletRequest request, String name){
        Cookie[] cookies = request.getCookies();
        if(null!=cookies) {
            for (Cookie cookie : cookies) {
                if (name.equals(cookie.getName())) {
                    return cookie.getValue();
                }
            }
        }
        return null;
    }
}
