package com.github.houbbbbb.sso.config;

import com.github.houbbbbb.sso.filter.SSOPFilter;
import com.github.houbbbbb.sso.nt.handler.HeartbeatClientHandler;
import com.github.houbbbbb.sso.nt.handler.HeartbeatServerHandler;
import com.github.houbbbbb.sso.nt.util.BeanUtil;
import com.github.houbbbbb.sso.scheduler.CacheClearJob;
import com.github.houbbbbb.sso.scheduler.ClientCheckJob;
import com.github.houbbbbb.sso.scheduler.ServerCheckJob;
import com.github.houbbbbb.sso.scheduler.ServerStartJob;
import com.github.houbbbbb.sso.service.SSOPAppService;
import com.github.houbbbbb.sso.service.SSOPServerService;
import com.github.houbbbbb.sso.service.SSOPUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

/**
 * @author : hbw
 * @desctiption :
 * @date : 2020-05-15 10:06
 */
@Configuration
@EnableConfigurationProperties({SSOPFilterConfig.class})
public class SSOPAutoConfig {
    @Autowired
    private SSOPFilterConfig ssopFilterConfig;
    @Autowired
    private CacheClearJob cacheClearJob;
    @Autowired
    private ServerCheckJob serverCheckJob;
    @Autowired
    private ServerStartJob serverStartJob;
    @Autowired
    private ClientCheckJob clientCheckJob;


    /**
     * filter
     */
    @Bean
    public SSOPFilter getSSOPFilter () {
        return new SSOPFilter(ssopFilterConfig);
    }

    /** service */

    @Bean
    public SSOPServerService getSSOPServerService () {
        return new SSOPServerService();
    }

    @Bean
    public SSOPAppService getSSOPAppService () {
        return new SSOPAppService();
    }

    @Bean
    public SSOPUserService getSSOPUserService () {
        return new SSOPUserService(ssopFilterConfig);
    }

    /** net */
    @PostConstruct
    @Bean
    public BeanUtil beanUtil () {
        return new BeanUtil();
    }

    @PostConstruct
    @Bean
    public HeartbeatClientHandler getHeartbeatClientHandler () {
        return new HeartbeatClientHandler(ssopFilterConfig);
    }

    @PostConstruct
    @Bean
    public HeartbeatServerHandler getHeartbeatServerHandler () {
        return new HeartbeatServerHandler(ssopFilterConfig);
    }


    /** 以下为定时工作 */

    @Bean
    public ServerStartJob getServerStartJob () {
        return new ServerStartJob(ssopFilterConfig);
    }

    @Bean
    public CacheClearJob getCacheClearJob () {
        return new CacheClearJob(ssopFilterConfig);
    }

    @Bean
    public ServerCheckJob getServerCheckJob () {
        return new ServerCheckJob(ssopFilterConfig);
    }

    @Bean
    public ClientCheckJob getClientCheckJob () { return new ClientCheckJob(ssopFilterConfig); }

    @PostConstruct
    public void cacheClear () {
        cacheClearJob.run();
    }

    @PostConstruct
    public void serverCheck () {
        serverCheckJob.run();
    }

    @PostConstruct
    public void serverStart () {
        serverStartJob.run();
    }

    @PostConstruct
    public void clientCheck () {
        clientCheckJob.run();
    }
}
