package com.github.houbbbbb.sso.filter;

import com.github.houbbbbb.sso.config.SSOPFilterConfig;
import com.github.houbbbbb.sso.cons.SSOPCacheConstants;
import com.github.houbbbbb.sso.cons.SSOPConstants;
import com.github.houbbbbb.sso.entity.AppInfoDTO;
import com.github.houbbbbb.sso.entity.SSOPUserDTO;
import com.github.houbbbbb.sso.nt.opt.ClientOpt;
import com.github.houbbbbb.sso.nt.util.DebugUtil;
import com.github.houbbbbb.sso.util.*;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/14
 **/
public class SSOPFilter implements Filter {
    private String       ssoServiceId;
    private String       pattern;
    private Boolean      enabled;
    private Handler      handler;
    private String       serviceId;
    private String       logout;
    private List<String> external;
    private Boolean      redirectHost;
    private String       hostPort;

    public SSOPFilter (SSOPFilterConfig ssopFilterConfig) {
        this.ssoServiceId = ssopFilterConfig.getSsoServiceId();
        this.pattern      = ssopFilterConfig.getPattern();
        this.enabled      = ssopFilterConfig.getEnabled();
        this.serviceId    = ssopFilterConfig.getServiceId();
        this.logout       = ssopFilterConfig.getLogout();
        this.external     = ssopFilterConfig.getExternal();
        this.redirectHost = ssopFilterConfig.getRedirectHost();
        this.hostPort     = ssopFilterConfig.getHostPort();
        this.handler      = new Handler();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        HttpServletResponse resp = (HttpServletResponse) response;
        if (enabled) {
            if (handler.matchPattern(req)) {
                if (handler.hasNotInCache(req)) {
                    if (handler.hasLogin(resp, req)) {
                        handler.pass(request, response, chain);
                    } else {
                        handler.redirect(resp, req);
                    }
                } else {
                    handler.pass(request, response, chain);
                }
            } else {
                handler.pass(request, response, chain);
            }
        } else {
            handler.pass(request, response, chain);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void destroy() {

    }

    private class Handler {
        private final String XX = "**";
        private final String X = "*";

        /*
        private boolean matchPattern(HttpServletRequest request){
            String uri = request.getRequestURI();
            String path = pattern.substring(0, pattern.length()-1);
            return null!=uri
                    && ((pattern.endsWith("*") && uri.startsWith(path)
                    || uri.equals(pattern))
            );
        }
        */

        private boolean matchPattern(HttpServletRequest request){
            String uri = request.getRequestURI();
            if(null == uri) {
                return false;
            }
            if(external(external, uri)){
                return false;
            }
            if(hasEqual(pattern, uri)){
                return true;
            }
            return hasMatch(pattern, uri);
        }

        private boolean external(List<String> external, String uri){
            if(null == external){
                return false;
            }
            for(String ptn: external){
                if(hasMatch(ptn, uri)){
                    return true;
                }
            }
            return false;
        }

        private boolean hasEqual(String pattern, String uri){
            return pattern.equals(uri);
        }

        private boolean hasMatch(String pattern, String uri){
            String path = "";
            int len = pattern.length();
            if(pattern.endsWith(XX)){
                path = pattern.substring(0, len-2);
            }else if(pattern.endsWith(X)){
                path = pattern.substring(0, len-1);
            }
            if(!"".equals(path)) {
                return uri.startsWith(path);
            }
            return false;
        }

        private String getHostAddr () {
            return ClientOpt.getAppHostByServiceIdLoadBalanced(ssoServiceId, ssoServiceId);
        }

        private String getIpAddr () {
            return ClientOpt.getAppIpByServiceIdLoadBalanced(ssoServiceId, ssoServiceId);
        }

        private Boolean hasNotInCache (HttpServletRequest request) {
            String key = getSession(request);
            if (null != key) {
//                System.out.println("is in cache key? " + key);
//                System.out.println("is in cache? " + SSOPCacheConstants.SSO_CACHE.containsKey(key));
                return !SSOPCacheConstants.SSO_CACHE.containsKey(key);
            }
            return true;
        }

        private Boolean hasLogin (HttpServletResponse response, HttpServletRequest request) {
            SSOPUserDTO ssopUserDTO = getRemoteUser(request);
            if (null != ssopUserDTO) {
                if (ssopUserDTO.getPermission()) {
                    String id = ssopUserDTO.getId();
                    String user = ssopUserDTO.getUser();
                    handler.remember(response, id, user);
                    ThreadLocalUtil.set(user);
                }
                return true;
            }
            return false;
        }

        private void pass (ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            chain.doFilter(request, response);
        }

        private String getSession () {
            return serviceId + SSOPConstants.SESSION;
        }

        private void setSession (HttpServletResponse response, String value) {
            CookieUtil.setCookie(response, getSession(), value);
        }

        private String getSession (HttpServletRequest request) {
            return CookieUtil.getCookie(request, getSession());
        }

        private void remember (HttpServletResponse response, String key, String value) {
            SSOPCacheConstants.SSO_CACHE.put(key, value);
            setSession(response, key);
        }

        private SSOPUserDTO getRemoteUser (HttpServletRequest request) {
            String re = HttpClientUtil.post(getUrl(), getParam(request));
            if (null != re) {
                return GsonUtil.toObj(re, SSOPUserDTO.class);
            }
            return null;
        }

        private PostParam getParam (HttpServletRequest request) {
            PostParam param = new PostParam();
            String session = request.getParameter("ssopsession");
            if (null == session) {
                session = getSession(request);
            }
            AppInfoDTO appInfoDTO = AppInfoDTO.create()
                    .setServiceId(serviceId)
                    .setSessionId(session);
            param.add(SSOPConstants.APP_INFO, GsonUtil.toJson(appInfoDTO));
            return param;
        }

        private String getUrl () {
            StringBuilder sb = new StringBuilder();
            sb.append(SSOPConstants.HTTP)
                    .append(getIpAddr())
                    .append(SSOPConstants.HAS_LOGIN);
            return sb.toString();
        }

        private void redirect (HttpServletResponse response, HttpServletRequest request) {
            String url = request.getRequestURL().toString();

            String addr = getIpAddr();

            if (redirectHost) {
                addr = getHostAddr();
                if (null != addr && addr.contains(":")) {
                    addr = addr.substring(0, addr.indexOf(":"));
                    addr = addr + ":" +hostPort;
                }
            }

            try {
                StringBuilder sb = new StringBuilder();
                sb.append(SSOPConstants.HTTP).append(addr)
                        .append(SSOPConstants.LOCAL_AUTH)
                        .append("?url=").append(SecretUtil.encodeBase64(url))
                        .append("&serviceId=").append(serviceId)
                        .append("&logoutUrl=").append(SecretUtil.encodeBase64(getLogoutUrl(url)));
                response.sendRedirect(sb.toString());
            } catch (Exception e) {e.printStackTrace();}
        }

        private String getLogoutUrl (String url) {
            if (null != url) {
                return url.replace(pattern, logout);
            }
            return null;
        }
    }
}
