package com.github.houbbbbb.sso.nt.entity;

import lombok.Getter;
import lombok.ToString;

import java.util.Objects;

/**
 * @author: hbw
 * @date: 2020/7/13
 **/
@Getter
@ToString
public class AppDTO {
    private String appName;
    private String serviceId;
    private String appType;
    private String hostName;
    private String ip;
    private Integer port;
    private String ssoServiceId;
    private String pattern;
    private String udpate;

    public AppDTO setUdpate(String udpate) {
        this.udpate = udpate;
        return this;
    }

    public AppDTO setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public AppDTO setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public AppDTO setServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public AppDTO setAppType(String appType) {
        this.appType = appType;
        return this;
    }

    public AppDTO setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public AppDTO setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public AppDTO setPort(Integer port) {
        this.port = port;
        return this;
    }

    public AppDTO setSsoServiceId(String ssoServiceId) {
        this.ssoServiceId = ssoServiceId;
        return this;
    }

    private AppDTO () {}
    public static AppDTO create () {
        return new AppDTO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) { return true; }
        if (o == null || getClass() != o.getClass()) { return false; }
        AppDTO appDTO = (AppDTO) o;
        return appName.equals(appDTO.appName) &&
                serviceId.equals(appDTO.serviceId) &&
                appType.equals(appDTO.appType) &&
                hostName.equals(appDTO.hostName) &&
                ip.equals(appDTO.ip) &&
                port.equals(appDTO.port) &&
                ssoServiceId.equals(appDTO.ssoServiceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appName, serviceId, appType, hostName, ip, port, ssoServiceId);
    }
}
