package com.github.houbbbbb.sso.nt.factory;

import com.github.houbbbbb.sso.nt.handler.ClientChannelHandler;
import com.github.houbbbbb.sso.nt.handler.ServerChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.socket.SocketChannel;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author: hbw
 * @date: 2020/7/7
 **/
public abstract class AbstractFactory implements Factory {
    @Override
    public ChannelInitializer<SocketChannel> getInitializer(ItemType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerChannelHandler getServerHandler(ItemType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientChannelHandler getClientHandler(ItemType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ThreadPoolExecutor getThread(ItemType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelOutboundHandlerAdapter getEncoder(ItemType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelInboundHandlerAdapter getDecoder(ItemType type) {
        throw new UnsupportedOperationException();
    }
}
