package com.github.houbbbbb.sso.nt.factory;

import com.github.houbbbbb.sso.nt.constants.CommonConstants;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class DecoderFactory extends AbstractFactory {

    @Override
    public ChannelInboundHandlerAdapter getDecoder (ItemType type) {
        ChannelInboundHandlerAdapter decoder = null;
        switch (type) {
            case STRING_DECODER: decoder = new StringDecoder(StandardCharsets.UTF_8); break;
            case LINE_BASED_DECODER: decoder = new LineBasedFrameDecoder(Integer.MAX_VALUE); break;
            default: break;
        }
        return decoder;
    }
}
