package com.github.houbbbbb.sso.nt.factory;

import com.github.houbbbbb.sso.nt.handler.ClientChannelHandler;
import com.github.houbbbbb.sso.nt.handler.ServerChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/7
 **/
public class NettyFactory implements Factory {

    private InitializerFactory initializerFactory = null;
    private ServerHandlerFactory serverHandlerFactory = null;
    private ClientHandlerFactory clientHandlerFactory = null;
    private ThreadFactory threadFactory = null;
    private EncoderFactory encoderFactory = null;
    private DecoderFactory decoderFactory = null;

    public NettyFactory () {
        initializerFactory = new InitializerFactory();
        serverHandlerFactory = new ServerHandlerFactory();
        clientHandlerFactory = new ClientHandlerFactory();
        threadFactory = new ThreadFactory();
        encoderFactory = new EncoderFactory();
        decoderFactory = new DecoderFactory();
    }

    @Override
    public ChannelInitializer getInitializer (ItemType type) {
        return initializerFactory.getInitializer(type);
    }

    @Override
    public ServerChannelHandler getServerHandler (ItemType type) {
       return serverHandlerFactory.getServerHandler(type);
    }

    @Override
    public ClientChannelHandler getClientHandler (ItemType type) {
        return clientHandlerFactory.getClientHandler(type);
    }

    @Override
    public ThreadPoolExecutor getThread (ItemType type) { return threadFactory.getThread(type); }

    @Override
    public ChannelOutboundHandlerAdapter getEncoder(ItemType type) {
        return encoderFactory.getEncoder(type);
    }

    @Override
    public ChannelInboundHandlerAdapter getDecoder(ItemType type) {
        return decoderFactory.getDecoder(type);
    }
}
