package com.github.houbbbbb.sso.nt.factory;


import com.github.houbbbbb.sso.nt.handler.ClientChannelHandler;
import com.github.houbbbbb.sso.nt.handler.ServerChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author: hbw
 * @date: 2020/7/7
 **/
public final class StaticFactory {
    private StaticFactory(){}
    private static Factory nettyFactory;
    static {
        nettyFactory = new NettyFactory();
    }

    public static ChannelInitializer getInitializer (ItemType type) {
        return nettyFactory.getInitializer(type);
    }

    public static ServerChannelHandler getServerHandler (ItemType type) {
        return nettyFactory.getServerHandler(type);
    }

    public static ClientChannelHandler getClientHandler (ItemType type) {
        return nettyFactory.getClientHandler(type);
    }

    public static ThreadPoolExecutor getThread (ItemType type) {
        return nettyFactory.getThread(type);
    }

    public static ChannelOutboundHandlerAdapter getEncoder(ItemType type) {
        return nettyFactory.getEncoder(type);
    }

    public static ChannelInboundHandlerAdapter getDecoder(ItemType type) {
        return nettyFactory.getDecoder(type);
    }
}
