package com.github.houbbbbb.sso.nt.filter;

import com.github.houbbbbb.sso.nt.entity.AppDTO;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: hbw
 * @date: 2020/7/16
 **/
public class ServiceIdFilter implements NetFilter {
    private String serviceId;
    public ServiceIdFilter (String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public List<AppDTO> filter(List<AppDTO> appDTOS) {
        return appDTOS.stream().filter(appDTO -> serviceId.equals(appDTO.getServiceId())).collect(Collectors.toList());
    }
}
