package com.github.houbbbbb.sso.nt.handler;

import com.github.houbbbbb.sso.config.SSOPFilterConfig;
import com.github.houbbbbb.sso.cons.SSOPCacheConstants;
import com.github.houbbbbb.sso.nt.constants.CacheConstants;
import com.github.houbbbbb.sso.nt.constants.CommonConstants;
import com.github.houbbbbb.sso.nt.constants.SwitchConstants;
import com.github.houbbbbb.sso.nt.entity.AppDTO;
import com.github.houbbbbb.sso.nt.opt.CacheOpt;
import com.github.houbbbbb.sso.nt.util.DebugUtil;
import com.github.houbbbbb.sso.nt.util.HandlerUtils;
import com.github.houbbbbb.sso.util.GsonUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;

import java.util.HashSet;
import java.util.Set;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/8
 **/
@ChannelHandler.Sharable
public class HeartbeatClientHandler extends ClientChannelHandler {

    private Long tick;
    private String appName;
    private String appType;
    private String serviceId;
    private String ssoServiceId;
    private Integer clientPort;
    private String pattern;
    public HeartbeatClientHandler (SSOPFilterConfig ssopFilterConfig) {
        this.tick = ssopFilterConfig.getTickTime();
        this.appName = ssopFilterConfig.getAppName();
        this.appType = ssopFilterConfig.getAppType();
        this.serviceId = ssopFilterConfig.getServiceId();
        this.ssoServiceId = ssopFilterConfig.getSsoServiceId();
        this.clientPort = ssopFilterConfig.getClientPort();
        this.pattern = ssopFilterConfig.getPattern();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        String rd = HandlerUtils.rd(msg);
        DebugUtil.debug("rd", rd);
        if (!CommonConstants.APP_INFO.equals(rd)) {
            if(rd.startsWith(CacheOpt.UPDATE_PREFIX)){
                // 在这里清除本地缓存
                String session = CacheOpt.getSession(rd);
                Set<String> cacheSet = GsonUtil.toObj(session, HashSet.class);
                cacheSet.forEach(SSOPCacheConstants.SSO_CACHE::remove);
            }else {
                CacheConstants.QUEUE_CACHE.offer(rd);
            }
        }
        Thread.sleep(tick);
        generateTraffic(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        generateTraffic(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        DebugUtil.debug("client", "client inactive shut");
        DebugUtil.warn("client", "client inactive shut");
        throw new RuntimeException("连接关闭");
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        DebugUtil.debug("exception : " + cause.getMessage(), "client exception shut");
        DebugUtil.warn("exception : " + cause.getMessage(), "client exception shut");
        cause.printStackTrace();
        ctx.close();
        SwitchConstants.clientStatus = true;
    }

    private void generateTraffic (ChannelHandlerContext ctx) {
        AppDTO appDTO = AppDTO.create().setAppName(appName).setServiceId(serviceId)
                .setAppType(appType).setSsoServiceId(ssoServiceId).setPort(clientPort)
                .setPattern(pattern);
        String update = CacheConstants.CLEAR_CACHE.poll();
        if(null != update && update.startsWith(CacheOpt.UPDATE_PREFIX)){
            appDTO.setUdpate(update);
        }
        String wt = GsonUtil.toJson(appDTO);
        DebugUtil.debug("wt", wt);
        HandlerUtils.wt(ctx, wt);
    }
}
