package com.github.houbbbbb.sso.scheduler;

import com.github.houbbbbb.sso.config.SSOPFilterConfig;
import com.github.houbbbbb.sso.cons.SSOPConstants;
import com.github.houbbbbb.sso.nt.handler.HeartbeatServerHandler;

import java.util.concurrent.TimeUnit;

/**
 * @author: hbw
 * @date: 2020/7/14
 **/
public class ServerCheckJob implements Job {
    private static final Integer INI_DELAY = 0;

    private static HeartbeatServerHandler.TickHandler tickHandler;
    static {
        tickHandler = new HeartbeatServerHandler.TickHandler();
    }

    private Long tickTime;
    private String type;
    private Boolean enabled;
    public ServerCheckJob (SSOPFilterConfig ssopFilterConfig) {
        this.tickTime = ssopFilterConfig.getTickTime();
        this.type = ssopFilterConfig.getType();
        this.enabled = ssopFilterConfig.getEnabled();
    }

    @Override
    public void run() {
        serverCheck();
    }

    /**
     * 心跳检测
     */
    public void serverCheck () {
        if (TypeJudge.server(type, enabled)) {
            Scheduler.getScheduler(Scheduler.Type.SERVER_CHECK).scheduleAtFixedRate(() -> {
                tickHandler.checkTimeout();
            }, INI_DELAY, tickTime, TimeUnit.MILLISECONDS);
        }
    }
}
