package com.github.houbbbbb.sso.service;

import com.github.houbbbbb.sso.entity.AppDO;
import com.github.houbbbbb.sso.nt.opt.ClientOpt;
import com.github.houbbbbb.sso.nt.entity.AppDTO;
import com.github.houbbbbb.sso.nt.util.AppConvertUtil;

import java.util.List;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class SSOPAppService {
    public List<AppDO> getAll () {
        return AppConvertUtil.convert(ClientOpt.getAppInfo());
    }

    public List<AppDO> getByServiceIdNameType (String serviceId, String type, String name) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceIdTypeName(serviceId, type, name));
    }

    public List<AppDO> getByServiceId (String serviceId) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceId(serviceId));
    }

    public List<AppDO> getByName (String name) {
        return AppConvertUtil.convert(ClientOpt.getAppByName(name));
    }

    public List<AppDO> getByType (String type) {
        return AppConvertUtil.convert(ClientOpt.getAppByType(type));
    }

    public List<AppDO> getBySsoServiceId (String ssoServiceId) {
        return AppConvertUtil.convert(ClientOpt.getAppBySsoServiceId(ssoServiceId));
    }

    public List<AppDO> getByServiceIdOrName (String serviceId, String name) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceIdOrName(serviceId, name));
    }

    public List<AppDO> getByServiceIdOrType (String serviceId, String type) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceIdOrType(serviceId, type));
    }

    public List<AppDO> getByServiceIdOrSsoServiceId (String serviceId, String ssoServiceId) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceIdOrSsoServiceId(serviceId, ssoServiceId));
    }

    public List<AppDO> getByNameOrType (String name, String type) {
        return AppConvertUtil.convert(ClientOpt.getAppByNameOrType(name, type));
    }

    public List<AppDO> getBySsoServiceIdOrName (String ssoServiceId, String name) {
        return AppConvertUtil.convert(ClientOpt.getAppBySsoServiceIdOrName(ssoServiceId, name));
    }

    public List<AppDO> getSsoServiceIdOrType (String ssoServiceId, String type) {
        return AppConvertUtil.convert(ClientOpt.getAppBySsoServiceIdOrType(ssoServiceId, type));
    }

    public List<AppDO> getByServiceIdAndName (String serviceId, String name) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceIdAndName(serviceId, name));
    }

    public List<AppDO> getByServiceIdAndType (String serviceId, String type) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceIdAndType(serviceId, type));
    }

    public List<AppDO> getByServiceIdAndSsoServiceId (String serviceId, String ssoServiceId) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceIdAndSsoServiceId(serviceId, ssoServiceId));
    }

    public List<AppDO> getByNameAndType (String name, String type) {
        return AppConvertUtil.convert(ClientOpt.getAppByNameAndType(name, type));
    }

    public List<AppDO> getBySsoServiceIdAndName (String ssoServiceId, String name) {
        return AppConvertUtil.convert(ClientOpt.getAppBySsoServiceIdAndName(ssoServiceId, name));
    }

    public List<AppDO> getSsoServiceIdAndType (String ssoServiceId, String type) {
        return AppConvertUtil.convert(ClientOpt.getAppBySsoServiceIdAndType(ssoServiceId, type));
    }

    public List<AppDO> getByServiceIdNot (String serviceId) {
        return AppConvertUtil.convert(ClientOpt.getAppByServiceIdNot(serviceId));
    }

    public List<AppDO> getByNameNot (String name) {
        return AppConvertUtil.convert(ClientOpt.getAppByNameNot(name));
    }

    public List<AppDO> getByTypeNot (String type) {
        return AppConvertUtil.convert(ClientOpt.getAppByTypeNot(type));
    }

    public List<AppDO> getBySsoServiceIdNot (String ssoServiceId) {
        return AppConvertUtil.convert(ClientOpt.getAppBySsoServiceIdNot(ssoServiceId));
    }

    public String getBalancedIp (String serviceId) {
        return ClientOpt.getAppIpByServiceIdLoadBalanced(serviceId);
    }

    public String getBalancedHost (String serviceId) {
        return ClientOpt.getAppHostByServiceIdLoadBalanced(serviceId);
    }

    public String getBalancedIp (String serviceId, String key) {
        return ClientOpt.getAppIpByServiceIdLoadBalanced(serviceId, key);
    }

    public String getBalancedHost (String serviceId, String key) {
        return ClientOpt.getAppHostByServiceIdLoadBalanced(serviceId, key);
    }
}
