package com.github.houbbbbb.sso.service;

import com.github.houbbbbb.sso.entity.AppDO;
import com.github.houbbbbb.sso.nt.entity.AppDTO;
import com.github.houbbbbb.sso.nt.opt.ServerOpt;
import com.github.houbbbbb.sso.nt.util.AppConvertUtil;
import org.apache.commons.beanutils.ConvertUtils;

import java.util.List;
import java.util.Random;

/**
 * @todo:
 * @author: hbw
 * @date: 2020/7/16
 **/
public class SSOPServerService {
    private Random random = new Random();

    public List<AppDO> getAll () {
        return AppConvertUtil.convert(ServerOpt.getAppInfo());
    }

    public List<AppDO> getByType (String type) {
        return AppConvertUtil.convert(ServerOpt.getAppByType(type));
    }

    public List<AppDO> getByName (String name) {
        return AppConvertUtil.convert(ServerOpt.getAppByName(name));
    }

    public List<AppDO> getByServiceId (String serviceId) {
        return AppConvertUtil.convert(ServerOpt.getAppByServiceId(serviceId));
    }

    public String getByServiceIdBalancedIp (String serviceId) {
        List<AppDO> appDOS = getByServiceId(serviceId);
        return appDOS.get(random.nextInt(appDOS.size())).getIpAddr();
    }

    public String getByServiceIdBalancedHost (String serviceId) {
        List<AppDO> appDOS = getByServiceId(serviceId);
        return appDOS.get(random.nextInt(appDOS.size())).getHostAddr();
    }

    public List<AppDO> getByTypeNot (String type) {
        return AppConvertUtil.convert(ServerOpt.getAppByTypeNot(type));
    }
}
