package com.github.houbbbbb.sso.util;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.security.SecureRandom;
import java.util.Random;

public class SecretUtil {

    private static final String charset = "UTF-8";
    private static final String AES = "AES";
    private static int keySizeAES = 128;
    public static final String HmacMD5 = "HmacMD5";

    public static String encodeMix(String res, String key){
        if (null == res) { return null; }
        res = toUtf8(res);
        if (null == res) { return null; }
        key = toUtf8(key);
        if (null == key) { return null; }
        key = encodeMD5(key, key);
        if (null == key) { return null; }
        String encode = encodeBase64(res);
        if (null == encode) { return null; }
        encode = getRandom()+encode;
        return encodeAES(encode, key);
    }

    public static String decodeMix(String res, String key){
        if (null == res) { return null; }
        res = toUtf8(res);
        if (null == res) { return null; }
        key = toUtf8(key);
        if (null == key) { return null; }
        key = encodeMD5(key, key);
        if (null == key) { return null; }
        String decode = decodeAES(res, key);
        if (null == decode) { return null; }
        decode = decode.substring(3);
        if (null == decode) { return null; }
        return decodeBase64(decode);
    }

    private static String getRandom(){
        Random random = new Random();
        String r1 = String.valueOf((char)(65+random.nextInt(26)));
        String r2 = String.valueOf((char)(97+random.nextInt(26)));
        String r3 = String.valueOf(random.nextInt(10));
        return r1+r2+r3;
    }

    public static String encodeAES(String res, String key) {
     return keyGeneratorES(res, AES, key, keySizeAES, true);
    }

    public static String decodeAES(String res, String key) {
     return keyGeneratorES(res, AES, key, keySizeAES, false);
    }

    public static String encodeBase64(String res){
        try {
            String encode = Base64.encodeBase64String(res.getBytes(charset));
            encode = encode.replaceAll("\r|\n", "");
            return encode;
        }catch (Exception e){
            return null;
        }
    }

    public static String decodeBase64(String res){
        try {
            String decode = new String(Base64.decodeBase64(res), charset);
            decode = decode.replaceAll("\r|\n", "");
            return decode;
        }catch (Exception e){
            return null;
        }
    }

    public static String encodeMD5(String res, String key) {
        return keyGeneratorMac(res, HmacMD5, key);
    }

    private static String keyGeneratorMac(String res,String algorithm,String key){
         try {
             byte[] keyBytes = key.getBytes(charset);
             SecretKey sk = new SecretKeySpec(keyBytes, algorithm);
             Mac mac = Mac.getInstance(algorithm);
             mac.init(sk);
             byte[] result = mac.doFinal(res.getBytes(charset));
             String encode = Base64.encodeBase64String(result);
             encode = encode.replaceAll("\r|\n", "");
             return encode;
         } catch (Exception e) {
             e.printStackTrace();
         }
         return null;
    }

    private static String keyGeneratorES(String res,String algorithm,String key,int keysize,boolean isEncode){
        try {
            SecretKeySpec sks = generateKey(key, algorithm, keysize);

            Cipher cipher = Cipher.getInstance(algorithm);
            if (isEncode) {
                 cipher.init(Cipher.ENCRYPT_MODE, sks);
                 byte[] resBytes = res.getBytes(charset);
                 return parseByte2HexStr(cipher.doFinal(resBytes));
            }else {
                cipher.init(Cipher.DECRYPT_MODE, sks);
                return new String(cipher.doFinal(parseHexStr2Byte(res)), charset);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String parseByte2HexStr(byte[] buf) {
         StringBuffer sb = new StringBuffer();
         for (int i = 0; i < buf.length; i++) {
                 String hex = Integer.toHexString(buf[i] & 0xFF);
                 if (hex.length() == 1) {
                         hex = '0' + hex;
                     }
                 sb.append(hex.toUpperCase());
             }
         return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
         if (hexStr.length() < 1) {return null;}
         byte[] result = new byte[hexStr.length()/2];
         for (int i = 0;i< hexStr.length()/2; i++) {
             int high = Integer.parseInt(hexStr.substring(i*2, i*2+1), 16);
             int low = Integer.parseInt(hexStr.substring(i*2+1, i*2+2), 16);
             result[i] = (byte) (high * 16 + low);
         }
         return result;
    }

    public static String toUtf8(String s){
        if(null!=s){
            byte[] bytes = s.getBytes();
            try {
                return new String(bytes, charset);
            }catch (Exception e){

            }
        }
        return null;
    }

    private static SecretKeySpec generateKey(String key, String algorithm, int keysize){
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key.getBytes(charset));
            keyGenerator.init(keysize, random);
            SecretKey sk = keyGenerator.generateKey();
            SecretKeySpec sks = new SecretKeySpec(sk.getEncoded(), algorithm);
            return sks;
        }catch (Exception e){}
        return null;
    }
}