/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.clickhouse;

import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import xenon.clickhouse.exception.ClickHouseErrCode;

public final class ClickHouseSQLConf$ {
    public static ClickHouseSQLConf$ MODULE$;
    private final ConfigEntry<Object> WRITE_BATCH_SIZE;
    private final ConfigEntry<Object> WRITE_MAX_RETRY;
    private final ConfigEntry<Object> WRITE_RETRY_INTERVAL;
    private final ConfigEntry<Seq<Object>> WRITE_RETRYABLE_ERROR_CODES;
    private final ConfigEntry<Object> WRITE_REPARTITION_NUM;
    private final ConfigEntry<Object> WRITE_REPARTITION_BY_PARTITION;
    private final ConfigEntry<Object> WRITE_REPARTITION_STRICTLY;
    private final ConfigEntry<Object> WRITE_DISTRIBUTED_USE_CLUSTER_NODES;
    private final ConfigEntry<Object> READ_DISTRIBUTED_USE_CLUSTER_NODES;
    private final ConfigEntry<Object> WRITE_DISTRIBUTED_CONVERT_LOCAL;
    private final ConfigEntry<Object> READ_DISTRIBUTED_CONVERT_LOCAL;
    private final ConfigEntry<Object> READ_SPLIT_BY_PARTITION_ID;
    private final ConfigEntry<Object> WRITE_LOCAL_SORT_BY_PARTITION;
    private final ConfigEntry<Object> WRITE_LOCAL_SORT_BY_KEY;
    private final ConfigEntry<Object> IGNORE_UNSUPPORTED_TRANSFORM;
    private final ConfigEntry<String> READ_COMPRESSION_CODEC;
    private final ConfigEntry<String> WRITE_COMPRESSION_CODEC;
    private final ConfigEntry<String> WRITE_FORMAT;

    static {
        new ClickHouseSQLConf$();
    }

    public ConfigEntry<Object> WRITE_BATCH_SIZE() {
        return this.WRITE_BATCH_SIZE;
    }

    public ConfigEntry<Object> WRITE_MAX_RETRY() {
        return this.WRITE_MAX_RETRY;
    }

    public ConfigEntry<Object> WRITE_RETRY_INTERVAL() {
        return this.WRITE_RETRY_INTERVAL;
    }

    public ConfigEntry<Seq<Object>> WRITE_RETRYABLE_ERROR_CODES() {
        return this.WRITE_RETRYABLE_ERROR_CODES;
    }

    public ConfigEntry<Object> WRITE_REPARTITION_NUM() {
        return this.WRITE_REPARTITION_NUM;
    }

    public ConfigEntry<Object> WRITE_REPARTITION_BY_PARTITION() {
        return this.WRITE_REPARTITION_BY_PARTITION;
    }

    public ConfigEntry<Object> WRITE_REPARTITION_STRICTLY() {
        return this.WRITE_REPARTITION_STRICTLY;
    }

    public ConfigEntry<Object> WRITE_DISTRIBUTED_USE_CLUSTER_NODES() {
        return this.WRITE_DISTRIBUTED_USE_CLUSTER_NODES;
    }

    public ConfigEntry<Object> READ_DISTRIBUTED_USE_CLUSTER_NODES() {
        return this.READ_DISTRIBUTED_USE_CLUSTER_NODES;
    }

    public ConfigEntry<Object> WRITE_DISTRIBUTED_CONVERT_LOCAL() {
        return this.WRITE_DISTRIBUTED_CONVERT_LOCAL;
    }

    public ConfigEntry<Object> READ_DISTRIBUTED_CONVERT_LOCAL() {
        return this.READ_DISTRIBUTED_CONVERT_LOCAL;
    }

    public ConfigEntry<Object> READ_SPLIT_BY_PARTITION_ID() {
        return this.READ_SPLIT_BY_PARTITION_ID;
    }

    public ConfigEntry<Object> WRITE_LOCAL_SORT_BY_PARTITION() {
        return this.WRITE_LOCAL_SORT_BY_PARTITION;
    }

    public ConfigEntry<Object> WRITE_LOCAL_SORT_BY_KEY() {
        return this.WRITE_LOCAL_SORT_BY_KEY;
    }

    public ConfigEntry<Object> IGNORE_UNSUPPORTED_TRANSFORM() {
        return this.IGNORE_UNSUPPORTED_TRANSFORM;
    }

    public ConfigEntry<String> READ_COMPRESSION_CODEC() {
        return this.READ_COMPRESSION_CODEC;
    }

    public ConfigEntry<String> WRITE_COMPRESSION_CODEC() {
        return this.WRITE_COMPRESSION_CODEC;
    }

    public ConfigEntry<String> WRITE_FORMAT() {
        return this.WRITE_FORMAT;
    }

    public static final /* synthetic */ boolean $anonfun$WRITE_RETRYABLE_ERROR_CODES$1(Seq codes) {
        return !codes.exists((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$2 -> x$2 <= ClickHouseErrCode.OK.code());
    }

    public static final /* synthetic */ boolean $anonfun$READ_DISTRIBUTED_USE_CLUSTER_NODES$1(boolean x$4) {
        return !x$4;
    }

    private ClickHouseSQLConf$() {
        MODULE$ = this;
        this.WRITE_BATCH_SIZE = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.batchSize").doc("The number of records per batch on writing to ClickHouse.").version("0.1.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)v -> v > 0, "`spark.clickhouse.write.batchSize` should be positive.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.WRITE_MAX_RETRY = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.maxRetry").doc("The maximum number of write we will retry for a single batch write failed with retryable codes.").version("0.1.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$1 -> x$1 >= 0, "Should be 0 or positive value. 0 means disable retry.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)3));
        this.WRITE_RETRY_INTERVAL = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.retryInterval").doc("The interval in seconds between write retry.").version("0.1.0").timeConf(TimeUnit.SECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)10L));
        int n = ClickHouseErrCode.MEMORY_LIMIT_EXCEEDED.code();
        this.WRITE_RETRYABLE_ERROR_CODES = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.retryableErrorCodes").doc("The retryable error codes returned by ClickHouse server when write failing.").version("0.1.0").intConf().toSequence().checkValue((Function1 & java.io.Serializable & Serializable)codes -> BoxesRunTime.boxToBoolean((boolean)ClickHouseSQLConf$.$anonfun$WRITE_RETRYABLE_ERROR_CODES$1(codes)), "Error code should be positive.").createWithDefault((Object)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)));
        this.WRITE_REPARTITION_NUM = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.repartitionNum").doc("Repartition data to meet the distributions of ClickHouse table is required before writing, use this conf to specific the repartition number, value less than 1 mean no requirement.").version("0.1.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)0));
        this.WRITE_REPARTITION_BY_PARTITION = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.repartitionByPartition").doc("Whether to repartition data by ClickHouse partition keys to meet the distributions of ClickHouse table before writing.").version("0.3.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.WRITE_REPARTITION_STRICTLY = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.repartitionStrictly").doc("If true, Spark will strictly distribute incoming records across partitions to satisfy the required distribution before passing the records to the data source table on write. Otherwise, Spark may apply certain optimizations to speed up the query but break the distribution requirement. Note, this configuration requires SPARK-37523, w/o this patch, it always act as `true`.").version("0.3.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.WRITE_DISTRIBUTED_USE_CLUSTER_NODES = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.distributed.useClusterNodes").doc("Write to all nodes of cluster when writing Distributed table.").version("0.1.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.READ_DISTRIBUTED_USE_CLUSTER_NODES = SQLConf$.MODULE$.buildConf("spark.clickhouse.read.distributed.useClusterNodes").doc("Read from all nodes of cluster when reading Distributed table.").version("0.1.0").booleanConf().checkValue((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClickHouseSQLConf$.$anonfun$READ_DISTRIBUTED_USE_CLUSTER_NODES$1(BoxesRunTime.unboxToBoolean((Object)x$4))), "`spark.clickhouse.read.distributed.useClusterNodes` is not support yet.").createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.WRITE_DISTRIBUTED_CONVERT_LOCAL = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.distributed.convertLocal").doc("When writing Distributed table, write local table instead of itself. If `true`, ignore `spark.clickhouse.write.distributed.useClusterNodes`.").version("0.1.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.READ_DISTRIBUTED_CONVERT_LOCAL = SQLConf$.MODULE$.buildConf("spark.clickhouse.read.distributed.convertLocal").doc(new StringBuilder(89).append("When reading Distributed table, read local table instead of itself. ").append("If `true`, ignore `").append(this.READ_DISTRIBUTED_USE_CLUSTER_NODES().key()).append("`.").toString()).version("0.1.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.READ_SPLIT_BY_PARTITION_ID = SQLConf$.MODULE$.buildConf("spark.clickhouse.read.splitByPartitionId").doc("If `true`, construct input partition filter by virtual column `_partition_id`, instead of partition value. There are known bugs to assemble SQL predication by partition value. This feature requires ClickHouse Server v21.6+").version("0.4.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.WRITE_LOCAL_SORT_BY_PARTITION = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.localSortByPartition").doc("If `true`, do local sort by partition before writing.").version("0.3.0").fallbackConf(this.WRITE_REPARTITION_BY_PARTITION());
        this.WRITE_LOCAL_SORT_BY_KEY = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.localSortByKey").doc("If `true`, do local sort by sort keys before writing.").version("0.3.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.IGNORE_UNSUPPORTED_TRANSFORM = SQLConf$.MODULE$.buildConf("spark.clickhouse.ignoreUnsupportedTransform").doc(new StringBuilder(326).append("ClickHouse supports using complex expressions as sharding keys or partition values, e.g. `cityHash64(col_1, col_2)`, and those can not be supported by Spark now. If `true`, ignore the unsupported expressions, otherwise fail fast w/ an exception. Note: when ").append("`").append(this.WRITE_DISTRIBUTED_CONVERT_LOCAL().key()).append("` is enabled, ignore unsupported sharding keys ").append("may corrupt the data.").toString()).version("0.4.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.READ_COMPRESSION_CODEC = SQLConf$.MODULE$.buildConf("spark.clickhouse.read.compression.codec").doc("The codec used to decompress data for reading. Supported codecs: none, lz4.").version("0.5.0").stringConf().createWithDefault((Object)"lz4");
        this.WRITE_COMPRESSION_CODEC = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.compression.codec").doc("The codec used to compress data for writing. Supported codecs: none, lz4.").version("0.3.0").stringConf().createWithDefault((Object)"lz4");
        this.WRITE_FORMAT = SQLConf$.MODULE$.buildConf("spark.clickhouse.write.format").doc("Serialize format for writing. Supported formats: JSONEachRow, ArrowStream").version("0.3.0").stringConf().createWithDefault((Object)"ArrowStream");
    }
}

